/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.http.response.interceptor;

import java.io.IOException;
import java.util.Optional;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Base64;

public class ResponseContentSHA256Interceptor
implements HttpResponseInterceptor {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.getContent() != null && entity.getContentLength() > 0L) {
            String hashHeaderValue = Optional.ofNullable(response.getFirstHeader("X-Content-SHA256")).map(NameValuePair::getValue).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElseThrow(() -> new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, String.format("Missing %s header in response. This header is expected when a response body is present. Http response was %s", "X-Content-SHA256", response.getStatusLine())));
            byte[] entityBytes = EntityUtils.toByteArray((HttpEntity)entity);
            this.validerBytesMotHashHeader(hashHeaderValue, entityBytes);
            response.setEntity((HttpEntity)new ByteArrayEntity(entityBytes));
        }
    }

    private void validerBytesMotHashHeader(String serverHash, byte[] entityBytes) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(entityBytes, 0, entityBytes.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        String ourHash = new String(Base64.encode((byte[])result));
        if (!serverHash.equals(ourHash)) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "X-Content-SHA256 header did not match actual response body");
        }
    }
}

