/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="entrypoint")
public class EntryPoint
extends Representation {
    @XmlElement(name="certificate", required=false)
    private String certificate;

    public EntryPoint(String certificate, Link ... links) {
        super(links);
        this.certificate = certificate;
    }

    public EntryPoint() {
    }

    public URI getInboxUri() {
        return this.getLinkByRelationName(Relation.GET_INBOX).getUri();
    }

    public URI getCreateMessageUri() {
        return this.getLinkByRelationName(Relation.CREATE_MESSAGE).getUri();
    }

    public URI getArchiveDocumentsUri() {
        return this.getLinkByRelationName(Relation.ARCHIVE_DOCUMENTS).getUri();
    }

    public URI getArchivesUri() {
        return this.getLinkByRelationName(Relation.GET_ARCHIVES).getUri();
    }

    public URI getCreateBatch() {
        return this.getLinkByRelationName(Relation.CREATE_BATCH).getUri();
    }

    public URI getBatchByUUID(UUID uuid) {
        return this.getLinkByRelationName(Relation.GET_BATCH).getUri().resolve(uuid.toString());
    }

    public URI getArchiveDocumentByUUIDUri(UUID uuid) {
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENT_BY_UUID).getUri().resolve(uuid.toString());
    }

    public URI getArchiveDocumentByReferenceUri(String referenceid) {
        String referenceIdBase64 = Base64.getEncoder().encodeToString(referenceid.getBytes(StandardCharsets.UTF_8));
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENTS_BY_REFERENCEID).getUri().resolve(referenceIdBase64);
    }

    public URI getPrintEncryptionCertificate() {
        return this.getLinkByRelationName(Relation.GET_PRINT_ENCRYPTION_CERTIFICATE).getUri();
    }

    public URI getSearchUri() {
        return this.getLinkByRelationName(Relation.SEARCH).getUri();
    }

    public URI getAutocompleteUri() {
        return this.getLinkByRelationName(Relation.AUTOCOMPLETE).getUri();
    }

    public URI getIdentificationUri() {
        return this.getLinkByRelationName(Relation.IDENTIFY_RECIPIENT).getUri();
    }

    public URI getIdentificationWithEncryptionKeyUri() {
        return this.getLinkByRelationName(Relation.IDENTIFY_RECIPIENT_WITH_ENCRYPTION_KEY).getUri();
    }

    public URI getDocumentEventsUri() {
        return this.getLinkByRelationName(Relation.DOCUMENT_EVENTS).getUri();
    }

    public URI getSenderInformationUri() {
        return this.getLinkByRelationName(Relation.GET_SENDER_INFORMATION).getUri();
    }

    public URI getAddTagUri() {
        return this.getLinkByRelationName(Relation.ADD_TAG).getUri();
    }

    public URI getRemoveTagUri() {
        return this.getLinkByRelationName(Relation.REMOVE_TAG).getUri();
    }

    public URI getTagsUri() {
        return this.getLinkByRelationName(Relation.GET_TAGS).getUri();
    }

    public URI getShareDocumentsRequestStateUri() {
        return this.getLinkByRelationName(Relation.GET_SHARE_DOCUMENTS_REQUEST_STATE).getUri();
    }

    public URI getCreateOrActivateUserAccountUri() {
        return this.getLinkByRelationName(Relation.CREATE_OR_ACTIVATE_USER_ACCOUNT).getUri();
    }

    public String getCertificate() {
        return this.certificate;
    }

    @XmlElement(name="link")
    protected List<Link> getLink() {
        return this.links;
    }

    protected void setLink(List<Link> links) {
        this.links = links;
    }
}

