/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import no.digipost.api.client.representations.BankAccountNumber;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="identification", propOrder={"nameAndAddress", "digipostAddress", "bankAccountNumber", "organisationNumber", "personalIdentificationNumber"})
@XmlRootElement(name="identification")
public class Identification {
    @XmlAttribute(name="include-personalias-for-digipost-user")
    protected boolean includePersonaliasForDigipostUser;
    @XmlElement(name="name-and-address", nillable=false)
    protected NameAndAddress nameAndAddress;
    @XmlElement(name="digipost-address", nillable=false)
    protected String digipostAddress;
    @XmlElement(name="bank-account-number", nillable=false)
    protected String bankAccountNumber;
    @XmlElement(name="personal-identification-number", nillable=false)
    protected String personalIdentificationNumber;
    @XmlElement(name="organisation-number", nillable=false)
    protected String organisationNumber;

    public Identification(NameAndAddress nameAndAddress) {
        this(nameAndAddress, false);
    }

    public Identification(NameAndAddress nameAndAddress, boolean includePersonaliasForDigipostUser) {
        this.nameAndAddress = nameAndAddress;
        this.includePersonaliasForDigipostUser = includePersonaliasForDigipostUser;
    }

    public Identification(DigipostAddress digipostAddress) {
        this(digipostAddress, false);
    }

    public Identification(DigipostAddress digipostAddress, boolean includePersonaliasForDigipostUser) {
        this.includePersonaliasForDigipostUser = includePersonaliasForDigipostUser;
        this.digipostAddress = digipostAddress.asString();
    }

    public Identification(PersonalIdentificationNumber personalIdentificationNumber) {
        this(personalIdentificationNumber, false);
    }

    public Identification(PersonalIdentificationNumber personalIdentificationNumber, boolean includePersonaliasForDigipostUser) {
        this.includePersonaliasForDigipostUser = includePersonaliasForDigipostUser;
        this.personalIdentificationNumber = personalIdentificationNumber.asString();
    }

    public Identification(OrganisationNumber organisationNumber) {
        this.includePersonaliasForDigipostUser = false;
        this.organisationNumber = organisationNumber.asString();
    }

    public Identification(BankAccountNumber bankAccountNumber) {
        this.includePersonaliasForDigipostUser = false;
        this.bankAccountNumber = bankAccountNumber.asString();
    }

    public Identification() {
    }

    public NameAndAddress getNameAndAddress() {
        return this.nameAndAddress;
    }

    public String getDigipostAddress() {
        return this.digipostAddress;
    }

    public String getPersonalIdentificationNumber() {
        return this.personalIdentificationNumber;
    }

    public String toString() {
        if (this.digipostAddress != null) {
            return this.digipostAddress;
        }
        if (this.bankAccountNumber != null) {
            return this.bankAccountNumber;
        }
        if (this.personalIdentificationNumber != null) {
            return this.personalIdentificationNumber;
        }
        if (this.nameAndAddress != null) {
            return this.nameAndAddress.toString();
        }
        return "empty";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Identification) {
            Identification that = (Identification)obj;
            return Objects.equals(this.digipostAddress, that.digipostAddress) && Objects.equals(this.includePersonaliasForDigipostUser, that.includePersonaliasForDigipostUser) && Objects.equals(this.nameAndAddress, that.nameAndAddress) && Objects.equals(this.personalIdentificationNumber, that.personalIdentificationNumber) && Objects.equals(this.organisationNumber, that.organisationNumber) && Objects.equals(this.bankAccountNumber, that.bankAccountNumber);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.digipostAddress, this.includePersonaliasForDigipostUser, this.nameAndAddress, this.personalIdentificationNumber, this.organisationNumber, this.bankAccountNumber);
    }
}

