/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.representations.BankAccountNumber;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EmailDetails;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.MessageRecipient;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PeppolAddresses;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;
import no.digipost.api.client.representations.PrintIfUnread;
import no.digipost.api.client.representations.RequestForRegistration;
import no.digipost.api.client.representations.SenderOrganization;
import no.digipost.api.client.representations.batch.Batch;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message", propOrder={"messageId", "senderId", "senderOrganization", "recipient", "deliveryTime", "invoiceReference", "primaryDocument", "attachments", "printIfUnread", "requestForRegistration", "batch"})
@XmlRootElement(name="message")
public class Message
implements MayHaveSender {
    @XmlElement(name="message-id")
    public final String messageId;
    @XmlElement(name="sender-id")
    public final Long senderId;
    @XmlElement(name="sender-organization")
    public final SenderOrganization senderOrganization;
    @XmlElement(name="recipient")
    public final MessageRecipient recipient;
    @XmlElement(name="delivery-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    public final ZonedDateTime deliveryTime;
    @XmlElement(name="invoice-reference")
    public final String invoiceReference;
    @XmlElement(name="primary-document", required=true)
    public final Document primaryDocument;
    @XmlElement(name="attachment")
    public final List<Document> attachments;
    @XmlElement(name="print-if-unread")
    public final PrintIfUnread printIfUnread;
    @XmlElement(name="request-for-registration")
    public final RequestForRegistration requestForRegistration;
    @XmlElement(name="batch")
    public final Batch batch;

    public static MessageBuilder newMessage(UUID messageId, Document primaryDocument) {
        return Message.newMessage(messageId.toString(), primaryDocument);
    }

    public static MessageBuilder newMessage(String messageId, Document primaryDocument) {
        return new MessageBuilder(messageId, primaryDocument);
    }

    Message() {
        this(null, null, null, null, null, null, null, null, null, null, null);
    }

    private Message(String messageId, Long senderId, SenderOrganization senderOrganization, MessageRecipient recipient, Document primaryDocument, Iterable<? extends Document> attachments, ZonedDateTime deliveryTime, String invoiceReference, PrintIfUnread printIfUnread, RequestForRegistration requestForRegistration, Batch batch) {
        this.messageId = messageId;
        this.senderId = senderId;
        this.senderOrganization = senderOrganization;
        this.recipient = recipient;
        this.primaryDocument = primaryDocument;
        this.invoiceReference = invoiceReference;
        this.deliveryTime = deliveryTime;
        this.attachments = new ArrayList<Document>();
        for (Document attachment : (Iterable)ObjectUtils.defaultIfNull(attachments, Collections.emptyList())) {
            this.attachments.add(attachment);
        }
        this.printIfUnread = printIfUnread;
        this.requestForRegistration = requestForRegistration;
        this.batch = batch;
    }

    public static Message copyPrintMessage(Message messageToCopy) {
        ArrayList<Document> tmpAttachments = new ArrayList<Document>();
        for (Document attachment : messageToCopy.attachments) {
            tmpAttachments.add(attachment.copyDocumentAndSetDigipostFileTypeToPdf());
        }
        return Message.copyMessage(messageToCopy, messageToCopy.primaryDocument.copyDocumentAndSetDigipostFileTypeToPdf(), tmpAttachments, messageToCopy.recipient.getPrintDetails());
    }

    public static Message copyMessageWithOnlyDigipostDetails(Message messageToCopy) {
        return Message.copyMessage(messageToCopy, messageToCopy.primaryDocument, messageToCopy.attachments, null);
    }

    private static Message copyMessage(Message messageToCopy, Document newPrimaryDocument, List<Document> newAttachments, PrintDetails newPrintDetails) {
        return new Message(messageToCopy.messageId, messageToCopy.senderId, messageToCopy.senderOrganization, messageToCopy.recipient.nameAndAddress, messageToCopy.recipient.digipostAddress, messageToCopy.recipient.personalIdentificationNumber, messageToCopy.recipient.organisationNumber, messageToCopy.deliveryTime, messageToCopy.invoiceReference, newPrimaryDocument, newAttachments, newPrintDetails, messageToCopy.recipient.bankAccountNumber, messageToCopy.printIfUnread, messageToCopy.requestForRegistration, messageToCopy.recipient.peppolAddresses, messageToCopy.recipient.emailDetails, messageToCopy.batch);
    }

    private Message(String messageId, Long senderId, SenderOrganization senderOrganization, NameAndAddress nameAndAddress, String digipostAddress, String personalIdentificationNumber, String organisationNumber, ZonedDateTime deliveryTime, String invoiceReference, Document primaryDocument, List<Document> attachments, PrintDetails printDetails, String bankAccountNumber, PrintIfUnread printIfUnread, RequestForRegistration requestForRegistration, PeppolAddresses peppolAddresses, EmailDetails emailDetails, Batch batch) {
        MessageRecipient recipient;
        this.messageId = messageId;
        this.senderId = senderId;
        this.senderOrganization = senderOrganization;
        this.recipient = recipient = new MessageRecipient(nameAndAddress, digipostAddress, peppolAddresses, personalIdentificationNumber, organisationNumber, printDetails, bankAccountNumber, emailDetails);
        this.deliveryTime = deliveryTime;
        this.invoiceReference = invoiceReference;
        this.primaryDocument = primaryDocument;
        this.attachments = attachments;
        this.printIfUnread = printIfUnread;
        this.requestForRegistration = requestForRegistration;
        this.batch = batch;
    }

    public Stream<Document> getAllDocuments() {
        return Stream.concat(Optional.ofNullable(this.primaryDocument).map(Stream::of).orElseGet(Stream::empty), this.attachments.stream());
    }

    public boolean isDirectPrint() {
        return this.recipient.isDirectPrint();
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId != null && this.messageId.equals(message.messageId);
    }

    public boolean hasAnyDocumentRequiringEncryption() {
        return this.getAllDocuments().anyMatch(Document::willBeEncrypted);
    }

    public Channel getChannel() {
        return this.recipient.isDirectPrint() ? Channel.PRINT : Channel.DIGIPOST;
    }

    public Comparator<? super Document> documentOrder() {
        return new Comparator<Document>(){
            final UUID[] uuids;
            {
                this.uuids = (UUID[])Message.this.getAllDocuments().map(d -> d.uuid).toArray(UUID[]::new);
            }

            @Override
            public int compare(Document d1, Document d2) {
                int d1Index = ArrayUtils.indexOf((Object[])this.uuids, (Object)d1.uuid);
                if (d1Index == -1) {
                    throw new CannotSortDocumentsUsingMessageOrder(d1.uuid, this.uuids);
                }
                int d2Index = ArrayUtils.indexOf((Object[])this.uuids, (Object)d2.uuid);
                if (d2Index == -1) {
                    throw new CannotSortDocumentsUsingMessageOrder(d2.uuid, this.uuids);
                }
                return d1Index - d2Index;
            }
        };
    }

    @Override
    public Optional<SenderId> getSenderId() {
        return Optional.ofNullable(this.senderId).map(SenderId::of);
    }

    @Override
    public Optional<SenderOrganization> getSenderOrganization() {
        return Optional.ofNullable(this.senderOrganization);
    }

    public String toString() {
        return "Message{messageId='" + this.messageId + "', senderId=" + this.senderId + ", senderOrganization=" + this.senderOrganization + ", recipient=" + this.recipient + ", deliveryTime=" + this.deliveryTime + ", invoiceReference='" + this.invoiceReference + "', primaryDocument=" + this.primaryDocument + ", attachments=" + this.attachments + "}";
    }

    public static class MessageBuilder {
        private String messageId;
        private Long senderId;
        private SenderOrganization senderOrganization;
        private MessageRecipient recipient;
        private ZonedDateTime deliveryTime;
        private Document primaryDocument;
        private final List<Document> attachments = new ArrayList<Document>();
        private String invoiceReference;
        private PrintIfUnread printIfUnread;
        private RequestForRegistration requestForRegistration;
        private Batch batch;

        private MessageBuilder(String messageId, Document primaryDocument) {
            this.messageId = messageId;
            this.primaryDocument = primaryDocument;
        }

        public MessageBuilder senderId(SenderId senderId) {
            this.senderId = senderId.value();
            return this;
        }

        public MessageBuilder senderOrganization(SenderOrganization senderOrganization) {
            this.senderOrganization = senderOrganization;
            return this;
        }

        public MessageBuilder recipient(MessageRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        public MessageBuilder recipient(DigipostAddress digipostAddress) {
            return this.recipient(new MessageRecipient(digipostAddress));
        }

        public MessageBuilder recipient(PersonalIdentificationNumber personalIdentificationNumber) {
            return this.recipient(new MessageRecipient(personalIdentificationNumber));
        }

        public MessageBuilder recipient(BankAccountNumber bankAccountNumber) {
            return this.recipient(new MessageRecipient(bankAccountNumber));
        }

        public MessageBuilder recipient(OrganisationNumber organisationNumber) {
            return this.recipient(new MessageRecipient(organisationNumber));
        }

        public MessageBuilder recipient(NameAndAddress nameAndAddress) {
            return this.recipient(new MessageRecipient(nameAndAddress));
        }

        public MessageBuilder recipient(PeppolAddresses peppolAddresses) {
            return this.recipient(new MessageRecipient(peppolAddresses));
        }

        public MessageBuilder printDetails(PrintDetails printDetails) {
            return this.recipient(new MessageRecipient(printDetails));
        }

        public MessageBuilder deliveryTime(ZonedDateTime deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        public MessageBuilder invoiceReference(String invoiceReference) {
            this.invoiceReference = invoiceReference;
            return this;
        }

        public MessageBuilder printIfUnread(PrintIfUnread printIfUnread) {
            this.printIfUnread = printIfUnread;
            return this;
        }

        public MessageBuilder requestForRegistration(RequestForRegistration requestForRegistration) {
            this.requestForRegistration = requestForRegistration;
            return this;
        }

        public MessageBuilder attachments(Document ... attachments) {
            return this.attachments(Arrays.asList(attachments));
        }

        public MessageBuilder attachments(Iterable<? extends Document> attachments) {
            ((Iterable)ObjectUtils.defaultIfNull(attachments, Collections.emptyList())).forEach(this.attachments::add);
            return this;
        }

        public MessageBuilder batch(UUID batchUUID) {
            this.batch = new Batch(batchUUID.toString());
            return this;
        }

        public Message build() {
            if (this.recipient == null) {
                throw new IllegalStateException("You must specify a recipient.");
            }
            if (this.senderId != null && this.senderOrganization != null) {
                throw new IllegalStateException("You can't set both senderId *and* senderOrganization.");
            }
            return new Message(this.messageId, this.senderId, this.senderOrganization, this.recipient, this.primaryDocument, this.attachments, this.deliveryTime, this.invoiceReference, this.printIfUnread, this.requestForRegistration, this.batch);
        }
    }

    public class CannotSortDocumentsUsingMessageOrder
    extends IllegalStateException {
        private CannotSortDocumentsUsingMessageOrder(UUID uuid, UUID[] validUuids) {
            super("Kan ikke sortere Document med uuid '" + uuid + "' etter rekkef\u00f8lgen i Message med id '" + Message.this.messageId + "' da dokumentet ikke eksisterer i meldingen.\nMeldingen har f\u00f8lgende dokumenter:\n  - " + StringUtils.join((Object[])validUuids, (String)"\n  - "));
        }
    }
}

