/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.ForeignAddress;
import no.digipost.api.client.representations.NorwegianAddress;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="print-recipient", propOrder={"name", "norwegianAddress", "foreignAddress"})
public class PrintRecipient {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(name="norwegian-address")
    protected NorwegianAddress norwegianAddress;
    @XmlElement(name="foreign-address")
    protected ForeignAddress foreignAddress;

    public PrintRecipient() {
    }

    public PrintRecipient(String name, NorwegianAddress norwegianAddress) {
        this.name = name;
        this.norwegianAddress = norwegianAddress;
    }

    public PrintRecipient(String name, ForeignAddress foreignAddress) {
        this.name = name;
        this.foreignAddress = foreignAddress;
    }

    public String getName() {
        return this.name;
    }

    public NorwegianAddress getNorwegianAddress() {
        return this.norwegianAddress;
    }

    public ForeignAddress getForeignAddress() {
        return this.foreignAddress;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean isSameRecipientAs(PrintRecipient other) {
        boolean nameMatches = this.trimEquals(this.name, other.name);
        if (this.norwegianAddress != null && other.norwegianAddress != null) {
            return nameMatches && this.norwegianAddress.isSameAddressAs(other.norwegianAddress);
        }
        if (this.foreignAddress != null && other.foreignAddress != null) {
            return nameMatches && this.foreignAddress.isSameAddressAs(other.foreignAddress);
        }
        return false;
    }

    private boolean trimEquals(String first, String second) {
        return StringUtils.trimToEmpty((String)first).equals(StringUtils.trimToEmpty((String)second));
    }
}

