/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.inbox;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import no.digipost.api.client.representations.AuthenticationLevel;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;
import no.digipost.api.client.representations.xml.URIXmlAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="inbox-document")
public class InboxDocument {
    @XmlElement
    protected long id;
    @XmlElement(name="reference-from-sender")
    protected String referenceFromSender;
    @XmlElement(required=true)
    protected String subject;
    @XmlElement(required=true)
    protected String sender;
    @XmlElement(name="delivery-time", required=true, type=String.class)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected ZonedDateTime deliveryTime;
    @XmlElement(name="first-accessed", type=String.class)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected ZonedDateTime firstAccessed;
    @XmlElement(name="authentication-level", required=true)
    @XmlSchemaType(name="string")
    protected AuthenticationLevel authenticationLevel;
    @XmlElement(name="content-type")
    protected String contentType;
    @XmlElement(name="content-uri")
    @XmlJavaTypeAdapter(value=URIXmlAdapter.class)
    protected URI contentUri;
    @XmlElement(name="delete-uri")
    @XmlJavaTypeAdapter(value=URIXmlAdapter.class)
    protected URI deleteUri;
    @XmlElement(name="attachment")
    protected List<InboxDocument> attachments = new ArrayList<InboxDocument>();

    public long getId() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSender() {
        return this.sender;
    }

    public ZonedDateTime getDeliveryTime() {
        return this.deliveryTime;
    }

    public ZonedDateTime getFirstAccessed() {
        return this.firstAccessed;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public String getContentType() {
        return this.contentType;
    }

    public URI getContentUri() {
        return this.contentUri;
    }

    public URI getDeleteUri() {
        return this.deleteUri;
    }

    public List<InboxDocument> getAttachments() {
        return this.attachments;
    }

    public Optional<String> getReferenceFromSender() {
        return Optional.ofNullable(this.referenceFromSender);
    }

    public String toString() {
        return "InboxDocument{id=" + this.id + ", subject='" + this.subject + "', sender='" + this.sender + "', deliveryTime=" + this.deliveryTime + ", firstAccessed=" + this.firstAccessed + ", authenticationLevel=" + this.authenticationLevel + ", contentType='" + this.contentType + "', contentUri=" + this.contentUri + ", deleteUri=" + this.deleteUri + this.getReferenceFromSender().map(ref -> ", referenceFromSender='" + ref + "'").orElse("") + ", attachments=" + this.attachments + "}";
    }
}

