/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.UUID;
import no.digipost.api.client.BrokerId;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.archive.ArchiveApi;
import no.digipost.api.client.batch.BatchApi;
import no.digipost.api.client.delivery.MessageDeliveryApi;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.document.DocumentApi;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.inbox.InboxApi;
import no.digipost.api.client.internal.ApiServiceImpl;
import no.digipost.api.client.internal.delivery.ArchiveDeliverer;
import no.digipost.api.client.internal.delivery.MessageDeliverer;
import no.digipost.api.client.internal.http.response.HttpResponseUtils;
import no.digipost.api.client.representations.AddDataLink;
import no.digipost.api.client.representations.AdditionalData;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.DocumentStatus;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.representations.accounts.Tag;
import no.digipost.api.client.representations.accounts.Tags;
import no.digipost.api.client.representations.accounts.UserAccount;
import no.digipost.api.client.representations.accounts.UserInformation;
import no.digipost.api.client.representations.archive.Archive;
import no.digipost.api.client.representations.archive.ArchiveDocument;
import no.digipost.api.client.representations.archive.ArchiveDocumentContent;
import no.digipost.api.client.representations.archive.Archives;
import no.digipost.api.client.representations.batch.Batch;
import no.digipost.api.client.representations.inbox.Inbox;
import no.digipost.api.client.representations.inbox.InboxDocument;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.api.client.representations.shareddocuments.ShareDocumentsRequestState;
import no.digipost.api.client.representations.shareddocuments.SharedDocumentContent;
import no.digipost.api.client.security.CryptoUtil;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.shareddocuments.SharedDocumentsApi;
import no.digipost.api.client.tag.TagApi;
import no.digipost.api.client.util.JAXBContextUtils;
import no.digipost.http.client3.DigipostHttpClientFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigipostClient {
    private static final Logger LOG;
    private final EventLogger eventLogger;
    private final MessageDeliveryApi messageApi;
    private final MessageDeliverer messageSender;
    private final ArchiveDeliverer archiveSender;
    private final InboxApi inboxApiService;
    private final DocumentApi documentApi;
    private final ArchiveApi archiveApi;
    private final BatchApi batchApi;
    private final TagApi tagApi;
    private final SharedDocumentsApi sharedDocumentsApi;

    public DigipostClient(DigipostClientConfig config, BrokerId brokerId, Signer signer) {
        this(config, brokerId, signer, DigipostHttpClientFactory.createDefaultBuilder());
    }

    public DigipostClient(DigipostClientConfig config, BrokerId brokerId, Signer signer, HttpClientBuilder clientBuilder) {
        this(config, new ApiServiceImpl(config, clientBuilder, brokerId, signer));
    }

    private DigipostClient(DigipostClientConfig config, ApiServiceImpl apiService) {
        this(config, apiService, apiService, apiService, apiService, apiService, apiService, apiService);
    }

    public DigipostClient(DigipostClientConfig config, MessageDeliveryApi apiService, InboxApi inboxApiService, DocumentApi documentApi, ArchiveApi archiveApi, BatchApi batchApi, TagApi tagApi, SharedDocumentsApi sharedDocumentsApi) {
        this.messageApi = apiService;
        this.inboxApiService = inboxApiService;
        this.documentApi = documentApi;
        this.archiveApi = archiveApi;
        this.batchApi = batchApi;
        this.tagApi = tagApi;
        this.sharedDocumentsApi = sharedDocumentsApi;
        this.messageSender = new MessageDeliverer(config, apiService);
        this.archiveSender = new ArchiveDeliverer(config, archiveApi);
        this.eventLogger = config.eventLogger.withDebugLogTo(LOG);
    }

    public OngoingDelivery.WithPrintFallback createMessage(Message message) {
        return this.messageSender.createMessage(message);
    }

    public OngoingDelivery.ForPrintOnly createPrintOnlyMessage(Message printMessage) {
        return this.messageSender.createPrintOnlyMessage(printMessage);
    }

    public IdentificationResult identifyRecipient(Identification identification) {
        IdentificationResult identificationResult;
        block8: {
            CloseableHttpResponse response = this.messageApi.identifyRecipient(identification);
            try {
                HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
                identificationResult = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), IdentificationResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DigipostClientException(ErrorCode.GENERAL_ERROR, (Throwable)e);
                }
            }
            response.close();
        }
        return identificationResult;
    }

    public void addData(AddDataLink addDataLink, AdditionalData data) {
        this.messageSender.addData(addDataLink, data);
    }

    public Recipients search(String searchString) {
        return this.messageApi.search(searchString);
    }

    public Autocomplete getAutocompleteSuggestions(String searchString) {
        return this.messageApi.searchSuggest(searchString);
    }

    public DocumentEvents getDocumentEvents(ZonedDateTime from, ZonedDateTime to, int offset, int maxResults) {
        return this.getDocumentEvents(null, from, to, offset, maxResults);
    }

    public DocumentEvents getDocumentEvents(SenderId senderId, ZonedDateTime from, ZonedDateTime to, int offset, int maxResults) {
        return this.documentApi.getDocumentEvents(null, null, senderId, from, to, offset, maxResults);
    }

    public DocumentEvents getDocumentEvents(String organisation, String partId, ZonedDateTime from, ZonedDateTime to, int offset, int maxResults) {
        return this.documentApi.getDocumentEvents(organisation, partId, null, from, to, offset, maxResults);
    }

    public SenderInformation getSenderInformation(SenderId senderId) {
        return this.messageApi.getSenderInformation(senderId);
    }

    public SenderInformation getSenderInformation(String orgnr, String avsenderenhet) {
        return this.messageApi.getSenderInformation(orgnr, avsenderenhet);
    }

    public DocumentStatus getDocumentStatus(Link linkToDocumentStatus) {
        return this.documentApi.getDocumentStatus(linkToDocumentStatus);
    }

    public DocumentStatus getDocumentStatus(SenderId senderId, UUID uuid) {
        return this.documentApi.getDocumentStatus(senderId, uuid);
    }

    public InputStream getContent(String path) {
        return this.documentApi.getDocumentContent(path);
    }

    public Archives getArchives() {
        return this.archiveApi.getArchives(null);
    }

    public Archives getArchives(SenderId senderId) {
        return this.archiveApi.getArchives(senderId);
    }

    public Archive getArchiveDocuments(URI uri) {
        return this.archiveApi.getArchiveDocuments(uri);
    }

    public Inbox getInbox(SenderId senderId) {
        return this.getInbox(senderId, 0, 100);
    }

    public Inbox getInbox(SenderId senderId, int offset, int limit) {
        return this.inboxApiService.getInbox(senderId, offset, limit);
    }

    public InputStream getInboxDocumentContent(InboxDocument inboxDocument) {
        return this.inboxApiService.getInboxDocumentContentStream(inboxDocument);
    }

    public void deleteInboxDocument(InboxDocument inboxDocument) {
        this.inboxApiService.deleteInboxDocument(inboxDocument);
    }

    public UserAccount createOrActivateUserAccount(SenderId senderId, UserInformation user) {
        return this.messageApi.createOrActivateUserAccount(senderId, user);
    }

    public void addTag(Tag tag) {
        this.tagApi.addTag(tag);
    }

    public void removeTag(Tag tag) {
        this.tagApi.removeTag(tag);
    }

    public Tags getTags(PersonalIdentificationNumber personalIdentificationNumber) {
        return this.tagApi.getTags(personalIdentificationNumber);
    }

    public ShareDocumentsRequestState getShareDocumentsRequestState(SenderId senderId, UUID shareDocumentsRequestUuid) {
        return this.sharedDocumentsApi.getShareDocumentsRequestState(senderId, shareDocumentsRequestUuid);
    }

    public InputStream getSharedDocumentContentStream(URI uri) {
        return this.sharedDocumentsApi.getSharedDocumentContentStream(uri);
    }

    public SharedDocumentContent getSharedDocumentContent(URI uri) {
        return this.sharedDocumentsApi.getSharedDocumentContent(uri);
    }

    public CloseableHttpResponse stopSharing(SenderId senderId, URI uri) {
        return this.sharedDocumentsApi.stopSharing(senderId, uri);
    }

    public ArchiveApi.ArchivingDocuments archiveDocuments(Archive archive) {
        return this.archiveSender.createArchive(archive);
    }

    public Archive getArchiveDocumentByUuid(UUID uri) {
        return this.archiveApi.getArchiveDocumentByUUID(null, uri);
    }

    public Archive getArchiveDocumentByUuid(SenderId senderId, UUID uuid) {
        return this.archiveApi.getArchiveDocumentByUUID(senderId, uuid);
    }

    public Archive addUniqueUUIDToArchiveDocument(UUID uuid, UUID newuuid) {
        return this.archiveApi.addUniqueUUIDToArchiveDocument(null, uuid, newuuid);
    }

    public Archive addUniqueUUIDToArchiveDocument(SenderId senderId, UUID uuid, UUID newuuid) {
        return this.archiveApi.addUniqueUUIDToArchiveDocument(senderId, uuid, newuuid);
    }

    public Archives getArchiveDocumentsByReferenceId(SenderId senderId, String referenceId) {
        return this.archiveApi.getArchiveDocumentsByReferenceId(senderId, referenceId);
    }

    public ArchiveDocumentContent getArchiveDocumentContent(URI uri) {
        return this.archiveApi.getArchiveDocumentContent(uri);
    }

    public InputStream getArchiveDocumentContentStream(URI uri) {
        return this.archiveApi.getArchiveDocumentContentStream(uri);
    }

    public void deleteArchiveDocument(URI archiveDocument) {
        this.archiveApi.deleteArchiveDocumentByUUID(archiveDocument);
    }

    public ArchiveDocument updateArchiveDocument(ArchiveDocument archiveDocument, URI uri) {
        return this.archiveApi.saveArchiveDocument(archiveDocument, uri);
    }

    public Batch createBatch(UUID batchUUID) {
        return this.batchApi.createBatch(batchUUID);
    }

    public Batch getBatchInformation(UUID batchUUID) {
        return this.batchApi.getBatchInformation(batchUUID);
    }

    public Batch completeBatch(Batch batch) {
        return this.batchApi.completeBatch(batch);
    }

    public void cancelBatch(Batch batch) {
        this.batchApi.cancelBatch(batch);
    }

    static {
        CryptoUtil.addBouncyCastleProviderAndVerify_AES256_CBC_Support();
        LOG = LoggerFactory.getLogger(DigipostClient.class);
    }
}

