/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.http.request.interceptor;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.internal.http.request.interceptor.ApacheHttpRequestToSign;
import no.digipost.api.client.internal.http.request.interceptor.RequestContentHashFilter;
import no.digipost.api.client.security.RequestMessageSignatureUtil;
import no.digipost.api.client.security.Signer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSignatureInterceptor
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSignatureInterceptor.class);
    private final Signer signer;
    private final RequestContentHashFilter hashFilter;
    private final EventLogger eventLogger;

    public RequestSignatureInterceptor(Signer signer, RequestContentHashFilter hashFilter) {
        this(signer, EventLogger.NOOP_LOGGER, hashFilter);
    }

    public RequestSignatureInterceptor(Signer signer, EventLogger eventLogger, RequestContentHashFilter hashFilter) {
        this.eventLogger = (eventLogger != null ? eventLogger : EventLogger.NOOP_LOGGER).withDebugLogTo(LOG);
        this.signer = signer;
        this.hashFilter = hashFilter;
    }

    private void setSignatureHeader(HttpRequest httpRequest) {
        String stringToSign = RequestMessageSignatureUtil.getCanonicalRequestRepresentation(new ApacheHttpRequestToSign(httpRequest));
        this.eventLogger.log(this.getClass().getSimpleName() + " beregnet streng som skal signeres:\n===START SIGNATURSTRENG===\n" + stringToSign + "===SLUTT SIGNATURSTRENG===");
        byte[] signatureBytes = this.signer.sign(stringToSign);
        String signature = new String(Base64.encode((byte[])signatureBytes));
        httpRequest.setHeader("X-Digipost-Signature", signature);
        this.eventLogger.log(this.getClass().getSimpleName() + " satt headeren X-Digipost-Signature=" + signature);
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)httpRequest;
            HttpEntity rqEntity = request.getEntity();
            if (rqEntity == null) {
                this.setSignatureHeader(httpRequest);
            } else {
                byte[] entityBytes = Optional.ofNullable(EntityUtils.toByteArray((HttpEntity)rqEntity)).orElseGet(() -> new byte[0]);
                this.hashFilter.settContentHashHeader(entityBytes, (HttpRequest)request);
                this.setSignatureHeader(httpRequest);
            }
        } else {
            this.setSignatureHeader(httpRequest);
        }
        httpContext.setAttribute("request-path", (Object)URI.create(httpRequest.getRequestLine().getUri()).getPath());
    }
}

