/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.BankAccountNumber;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.EmailDetails;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PeppolAddresses;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message-recipient", propOrder={"nameAndAddress", "digipostAddress", "peppolAddresses", "personalIdentificationNumber", "organisationNumber", "printDetails", "bankAccountNumber", "emailDetails"})
public class MessageRecipient {
    @XmlElement(name="name-and-address", nillable=false)
    protected NameAndAddress nameAndAddress;
    @XmlElement(name="digipost-address", nillable=false)
    protected String digipostAddress;
    @XmlElement(name="peppol-addresses", nillable=false)
    protected PeppolAddresses peppolAddresses;
    @XmlElement(name="personal-identification-number", nillable=false)
    protected String personalIdentificationNumber;
    @XmlElement(name="organisation-number", nillable=false)
    protected String organisationNumber;
    @XmlElement(name="print-details", nillable=false)
    protected PrintDetails printDetails;
    @XmlElement(name="bank-account-number", nillable=false)
    protected String bankAccountNumber;
    @XmlElement(name="email-details", nillable=false)
    protected EmailDetails emailDetails;

    public MessageRecipient() {
    }

    MessageRecipient(NameAndAddress nameAndAddress, String digipostAddress, PeppolAddresses peppolAddresses, String personalIdentificationNumber, String organisationNumber, PrintDetails printDetails, String bankAccountNumber, EmailDetails emailDetails) {
        this.nameAndAddress = nameAndAddress;
        this.digipostAddress = digipostAddress;
        this.peppolAddresses = peppolAddresses;
        this.personalIdentificationNumber = personalIdentificationNumber;
        this.organisationNumber = organisationNumber;
        this.printDetails = printDetails;
        this.bankAccountNumber = bankAccountNumber;
        this.emailDetails = emailDetails;
    }

    public MessageRecipient(PersonalIdentificationNumber id) {
        this.personalIdentificationNumber = id.asString();
    }

    public MessageRecipient(BankAccountNumber bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber.asString();
    }

    public MessageRecipient(DigipostAddress digipostAddress) {
        this.digipostAddress = digipostAddress.asString();
    }

    public MessageRecipient(PeppolAddresses peppolAddresses) {
        this.peppolAddresses = peppolAddresses;
    }

    public MessageRecipient(OrganisationNumber organisationNumber) {
        this.organisationNumber = organisationNumber.asString();
    }

    public MessageRecipient(NameAndAddress nameAndAddress) {
        this.nameAndAddress = nameAndAddress;
    }

    public MessageRecipient(PersonalIdentificationNumber id, PrintDetails printDetails) {
        this(id);
        this.printDetails = printDetails;
    }

    public MessageRecipient(DigipostAddress digipostAddress, PrintDetails printDetails) {
        this(digipostAddress);
        this.printDetails = printDetails;
    }

    public MessageRecipient(NameAndAddress nameAndAddress, PrintDetails printDetails) {
        this(nameAndAddress);
        this.printDetails = printDetails;
    }

    public MessageRecipient(OrganisationNumber organisationNumber, PrintDetails printDetails) {
        this(organisationNumber);
        this.printDetails = printDetails;
    }

    public MessageRecipient(EmailDetails emailDetails) {
        this.emailDetails = emailDetails;
    }

    public MessageRecipient(PrintDetails printDetails) {
        this.printDetails = printDetails;
    }

    public NameAndAddress getNameAndAddress() {
        return this.nameAndAddress;
    }

    public String getDigipostAddress() {
        return this.digipostAddress;
    }

    public String getPersonalIdentificationNumber() {
        return this.personalIdentificationNumber;
    }

    public PeppolAddresses getPeppolAddresses() {
        return this.peppolAddresses;
    }

    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public String getOrganisationNumber() {
        return this.organisationNumber;
    }

    public PrintDetails getPrintDetails() {
        return this.printDetails;
    }

    public boolean isDirectPrint() {
        return this.hasPrintDetails() && !this.hasDigipostIdentification();
    }

    public boolean hasPrintDetails() {
        return this.printDetails != null;
    }

    public boolean hasDigipostIdentification() {
        return this.digipostAddress != null || this.personalIdentificationNumber != null || this.nameAndAddress != null || this.organisationNumber != null;
    }

    public Identification toIdentification() {
        if (this.isDirectPrint()) {
            throw new IllegalStateException("MessageRecipient mangler identifikasjonsdetaljer.");
        }
        if (this.digipostAddress != null) {
            return new Identification(new DigipostAddress(this.digipostAddress));
        }
        if (this.nameAndAddress != null) {
            return new Identification(this.nameAndAddress);
        }
        if (this.organisationNumber != null) {
            return new Identification(new OrganisationNumber(this.organisationNumber));
        }
        if (this.personalIdentificationNumber != null) {
            return new Identification(new PersonalIdentificationNumber(this.personalIdentificationNumber));
        }
        throw new DigipostClientException(ErrorCode.CLIENT_ERROR, "Ukjent identifikationstype.");
    }
}

