/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.archive;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import java.time.Clock;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import no.digipost.api.client.representations.ContentHash;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.archive.ArchiveDocumentAttribute;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="archive-document", propOrder={"uuid", "fileName", "fileType", "referenceid", "contentType", "contentHash", "attributes", "archivedTime", "deletionTime", "links"})
@XmlRootElement(name="archive-document")
public class ArchiveDocument
extends Representation {
    @XmlElement(required=true)
    public final UUID uuid;
    @XmlElement(name="file-name", nillable=false)
    protected String fileName;
    @XmlElement(name="file-type", required=true)
    protected String fileType;
    @XmlElement(nillable=false)
    protected String referenceid;
    @XmlElement(name="content-type", nillable=false)
    protected String contentType;
    @XmlElement(name="content-hash", nillable=false)
    protected ContentHash contentHash;
    @XmlElement(nillable=false)
    protected List<ArchiveDocumentAttribute> attributes;
    @XmlElement(name="archived-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected ZonedDateTime archivedTime;
    @XmlElement(name="deletion-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected ZonedDateTime deletionTime;

    public ArchiveDocument() {
        this((UUID)null, (String)null, (String)null, (String)null);
    }

    public ArchiveDocument(UUID uuid, String fileName, String fileType, String contentType) {
        super(new Link[0]);
        this.uuid = uuid;
        this.fileName = fileName;
        this.fileType = fileType;
        this.contentType = contentType;
        this.attributes = new ArrayList<ArchiveDocumentAttribute>();
    }

    public ArchiveDocument withAttribute(String key, String value) {
        Optional<ArchiveDocumentAttribute> first = this.attributes.stream().filter(s -> s.key.equals(key)).findFirst();
        if (first.isPresent()) {
            first.get().value = value;
        } else {
            this.attributes.add(new ArchiveDocumentAttribute(key, value));
        }
        return this;
    }

    public ArchiveDocument withAttributes(Map<String, String> attributes) {
        attributes.forEach(this::withAttribute);
        return this;
    }

    public ArchiveDocument withReferenceId(String referenceid) {
        this.referenceid = referenceid;
        return this;
    }

    public ArchiveDocument withDeletionTime(ZonedDateTime deletionTime) {
        this.deletionTime = deletionTime;
        return this;
    }

    public ArchiveDocument withDeleteAfter(Period duration, Clock clock) {
        this.deletionTime = ZonedDateTime.now(clock).plus(duration);
        return this;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getReferenceid() {
        return this.referenceid;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ContentHash getContentHash() {
        return this.contentHash;
    }

    public void setContentHash(ContentHash value) {
        this.contentHash = value;
    }

    public List<ArchiveDocumentAttribute> getAttributes() {
        return this.attributes;
    }

    public ZonedDateTime getArchivedTime() {
        return this.archivedTime;
    }

    public ZonedDateTime getDeletionTime() {
        return this.deletionTime;
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links;
    }

    public URI getDocumentByUUID() {
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENT_BY_UUID).getUri();
    }

    public URI getDocumentContent() {
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENT_CONTENT).getUri();
    }

    public URI getUpdate() {
        return this.getLinkByRelationName(Relation.SELF_UPDATE).getUri();
    }

    public URI getDelete() {
        return this.getLinkByRelationName(Relation.SELF_DELETE).getUri();
    }

    public URI getAddUniqueUUID() {
        return this.getLinkByRelationName(Relation.ADD_UNIQUE_UUID).getUri();
    }

    public URI getDocumentContentStream() {
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENT_CONTENT_STREAM).getUri();
    }

    public String toString() {
        return "ArchiveDocument{uuid=" + this.uuid + ", fileName='" + this.fileName + "', fileType='" + this.fileType + "', referenceid='" + this.referenceid + "', contentType='" + this.contentType + "', contentHash=" + this.contentHash.getHashAlgorithm() + ":" + this.contentHash.getHash() + ", attributes=" + this.attributes + ", archivedTime=" + this.archivedTime + ", deletionTime=" + this.deletionTime + "}";
    }
}

