/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.batch;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.batch.BatchStatus;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="batch", propOrder={"uuid", "status", "countDigipost", "countPrint", "links"})
@XmlRootElement(name="batch")
public class Batch
extends Representation {
    @XmlElement(required=true)
    protected String uuid;
    @XmlSchemaType(name="string")
    protected BatchStatus status;
    @XmlElement(name="count-digipost")
    protected Integer countDigipost;
    @XmlElement(name="count-print")
    protected Integer countPrint;

    public Batch() {
        super(new Link[0]);
    }

    public Batch(String uuid) {
        super(new Link[0]);
        this.uuid = uuid;
    }

    public Batch(String uuid, BatchStatus status, Integer countDigipost, Integer countPrint, List<Link> links) {
        super(new Link[0]);
        this.uuid = uuid;
        this.status = status;
        this.countDigipost = countDigipost;
        this.countPrint = countPrint;
        this.links = links;
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links;
    }

    protected void setLink(List<Link> links) {
        this.links = links;
    }

    public URI getCompleteBatch() {
        return this.getLinkByRelationName(Relation.COMPLETE_BATCH).getUri();
    }

    public URI getCancelBatch() {
        return this.getLinkByRelationName(Relation.SELF_DELETE).getUri();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with uuid '" + this.uuid + "'" + Optional.ofNullable(this.status).map(t -> ", status '" + t + "'").orElse("") + Optional.ofNullable(this.countDigipost).map(t -> ", Digipost: '" + t + "'").orElse("") + Optional.ofNullable(this.countPrint).map(t -> ", Print: '" + t + "'").orElse("");
    }

    public String getUuid() {
        return this.uuid;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public Integer getCountDigipost() {
        return this.countDigipost;
    }

    public Integer getCountPrint() {
        return this.countPrint;
    }
}

