/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.sender;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.Objects;
import java.util.Optional;
import no.digipost.api.client.representations.sender.SenderFeatureName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="feature", propOrder={"value"})
public final class SenderFeature {
    @XmlValue
    private final String value;
    @XmlAttribute(name="param")
    private final String param;

    public SenderFeature() {
        this(null, null);
    }

    public SenderFeature(SenderFeatureName name, String param) {
        this.value = name != null ? name.identificator : null;
        this.param = param;
    }

    public SenderFeatureName getName() {
        return SenderFeatureName.from(this.value);
    }

    public String getParam() {
        return this.param;
    }

    public int getIntParam() {
        try {
            return Integer.parseInt(this.getParam());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("The sender feature " + this.value + " has the parameter '" + this.param + "', which can not be converted to an int. (" + e.getMessage() + ")", e);
        }
    }

    public long getLongParam() {
        try {
            return Long.parseLong(this.getParam());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("The sender feature " + this.value + " has the parameter '" + this.param + "', which can not be converted to an long. (" + e.getMessage() + ")", e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof SenderFeature) {
            SenderFeature that = (SenderFeature)other;
            return Objects.equals(this.value, that.value) && Objects.equals(this.param, that.param);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.param);
    }

    public String toString() {
        return this.value + Optional.ofNullable(this.param).map(p -> ": " + p).orElse("");
    }
}

