/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.sender;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import java.util.stream.Collectors;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.representations.sender.SenderFeature;
import no.digipost.api.client.representations.sender.SenderFeatureName;
import no.digipost.api.client.representations.sender.SenderStatus;
import no.digipost.print.validate.PdfValidationSettings;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="sender-information", propOrder={"senderId", "status", "supportedFeatures"})
@XmlRootElement(name="sender-information")
public class SenderInformation {
    @XmlElement(name="sender-id", nillable=false)
    private Long senderId;
    @XmlElement(required=true)
    @XmlSchemaType(name="string")
    private SenderStatus status;
    @XmlElementWrapper(name="supported-features")
    @XmlElement(name="feature", nillable=false)
    private List<SenderFeature> supportedFeatures;

    public SenderInformation() {
    }

    public SenderInformation(SenderId senderId, SenderStatus status, List<SenderFeature> supportedFeatures) {
        this.senderId = senderId != null ? Long.valueOf(senderId.value()) : null;
        this.status = status;
        this.supportedFeatures = supportedFeatures == null || supportedFeatures.isEmpty() ? null : supportedFeatures;
    }

    public Long getSenderId() {
        return this.senderId;
    }

    public boolean is(SenderStatus status) {
        return this.status == status;
    }

    public List<SenderFeature> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public boolean hasEnabled(SenderFeatureName featureName) {
        return this.get(featureName) != null;
    }

    public SenderFeature get(SenderFeatureName featureName) {
        if (this.supportedFeatures == null) {
            return null;
        }
        for (SenderFeature feature : this.supportedFeatures) {
            if (!featureName.equals(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.status.toString());
        if (this.status != SenderStatus.NO_INFO_AVAILABLE) {
            s.append(" - id: ").append(this.senderId).append(", supported features: ").append(this.supportedFeatures.stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        return s.toString();
    }

    public PdfValidationSettings getPdfValidationSettings() {
        SenderFeature positiveBleed = this.get(SenderFeatureName.PRINTVALIDATION_POSITIVE_BLEED);
        SenderFeature negativeBleed = this.get(SenderFeatureName.PRINTVALIDATION_NEGATIVE_BLEED);
        return new PdfValidationSettings(this.hasEnabled(SenderFeatureName.PRINTVALIDATION_MARGINS_LEFT), this.hasEnabled(SenderFeatureName.PRINTVALIDATION_FONTS), this.hasEnabled(SenderFeatureName.PRINTVALIDATION_PAGEAMOUNT), this.hasEnabled(SenderFeatureName.PRINTVALIDATION_PDFVERSION), positiveBleed != null ? positiveBleed.getIntParam() : 0, negativeBleed != null ? negativeBleed.getIntParam() : 10);
    }
}

