/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStream;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.MessageSender;
import no.digipost.api.client.filters.ContentMD5Filter;
import no.digipost.api.client.filters.DateFilter;
import no.digipost.api.client.filters.SignatureFilter;
import no.digipost.api.client.filters.UserAgentFilter;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.ContentType;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.security.FileKeystoreSigner;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.util.JerseyClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigipostClient {
    public static final EventLogger NOOP_EVENT_LOGGER = new EventLogger(){

        @Override
        public void log(String eventText) {
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(DigipostClient.class);
    private final EventLogger eventLogger;
    private final ApiService apiService;

    public DigipostClient(String digipostUrl, long senderAccountId, InputStream certificateP12File, String certificatePassword) {
        this(digipostUrl, senderAccountId, new FileKeystoreSigner(certificateP12File, certificatePassword), NOOP_EVENT_LOGGER);
    }

    public DigipostClient(String digipostUrl, long senderAccountId, InputStream certificateP12File, String sertifikatPassord, EventLogger eventLogger) {
        this(digipostUrl, senderAccountId, new FileKeystoreSigner(certificateP12File, sertifikatPassord), eventLogger);
    }

    public DigipostClient(String digipostUrl, long senderAccountId, Signer signer) {
        this(digipostUrl, senderAccountId, signer, NOOP_EVENT_LOGGER);
    }

    public DigipostClient(String digipostUrl, long senderAccountId, Signer signer, EventLogger eventLogger) {
        this.eventLogger = eventLogger != null ? eventLogger : NOOP_EVENT_LOGGER;
        Client client = JerseyClientProvider.getClient();
        WebResource webResource = client.resource(digipostUrl);
        webResource.addFilter((ClientFilter)new ContentMD5Filter(eventLogger));
        webResource.addFilter((ClientFilter)new SignatureFilter(signer, eventLogger));
        webResource.addFilter((ClientFilter)new DateFilter(eventLogger));
        webResource.addFilter((ClientFilter)new UserAgentFilter());
        this.log("Initialiserte Jersey-klient mot " + digipostUrl);
        this.apiService = new ApiService(webResource, senderAccountId);
    }

    public MessageDelivery sendMessage(Message message, InputStream letterContent) {
        return this.sendMessage(message, letterContent, ContentType.PDF);
    }

    public MessageDelivery sendMessage(Message message, InputStream letterContent, ContentType contentType) {
        return new MessageSender(this.apiService, this.eventLogger).sendMessage(message, letterContent, contentType);
    }

    public MessageDelivery sendMessageToDigipostOrDeliverToPrint(Message message, ContentType digipostMessageContentType, InputStream digipostMessageContent) {
        return this.sendMessageToDigipostOrDeliverToPrint(message, digipostMessageContentType, digipostMessageContent, digipostMessageContent);
    }

    public MessageDelivery sendMessageToDigipostOrDeliverToPrint(Message message, ContentType digipostMessageContentType, InputStream digipostMessageContent, InputStream printMessageContent) {
        return new MessageSender(this.apiService, this.eventLogger).sendMessage(message, digipostMessageContent, digipostMessageContentType, printMessageContent);
    }

    public MessageDelivery deliverToPrint(Message printMessage, InputStream printMessageContent) {
        assert (printMessage.isDirectPrint()) : "Direct print messages cannot have DigipostAddress, PersonalIdentificationNumber or NameAndAddress";
        return new MessageSender(this.apiService, this.eventLogger).sendMessage(printMessage, null, null, printMessageContent);
    }

    public Recipients search(String searchString) {
        return this.apiService.search(searchString);
    }

    public Autocomplete getAutocompleteSuggestions(String searchString) {
        return this.apiService.searchSuggest(searchString);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    public void addFilter(ClientFilter filter) {
        this.apiService.addFilter(filter);
    }
}

