/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="recipient-identification", propOrder={"nameAndAddress", "digipostAddress", "personalIdentificationNumber", "printDetails"})
public class RecipientIdentification {
    @XmlElement(name="name-and-address", nillable=false)
    protected NameAndAddress nameAndAddress;
    @XmlElement(name="digipost-address", nillable=false)
    protected String digipostAddress;
    @XmlElement(name="personal-identification-number", nillable=false)
    protected String personalIdentificationNumber;
    @XmlElement(name="print-details", nillable=false)
    protected PrintDetails printDetails;

    public RecipientIdentification() {
    }

    public RecipientIdentification(PersonalIdentificationNumber id) {
        this.personalIdentificationNumber = id.asString();
    }

    public RecipientIdentification(DigipostAddress digipostAddress) {
        this.digipostAddress = digipostAddress.asString();
    }

    public RecipientIdentification(NameAndAddress nameAndAddress) {
        this.nameAndAddress = nameAndAddress;
    }

    public RecipientIdentification(PersonalIdentificationNumber id, PrintDetails printDetails) {
        this(id);
        this.printDetails = printDetails;
    }

    public RecipientIdentification(DigipostAddress digipostAddress, PrintDetails printDetails) {
        this(digipostAddress);
        this.printDetails = printDetails;
    }

    public RecipientIdentification(NameAndAddress nameAndAddress, PrintDetails printDetails) {
        this.nameAndAddress = nameAndAddress;
        this.printDetails = printDetails;
    }

    public RecipientIdentification(PrintDetails printDetails) {
        this.printDetails = printDetails;
    }

    public NameAndAddress getNameAndAddress() {
        return this.nameAndAddress;
    }

    public String getDigipostAddress() {
        return this.digipostAddress;
    }

    public String getPersonalIdentificationNumber() {
        return this.personalIdentificationNumber;
    }

    public PrintDetails getPrintDetails() {
        return this.printDetails;
    }

    public boolean isDirectPrint() {
        return this.printDetails != null && this.digipostAddress == null && this.personalIdentificationNumber == null && this.nameAndAddress == null;
    }
}

