/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.security;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import no.digipost.api.client.security.RequestToSign;

public class MessageSignatureUtil {
    private static final List<String> HEADERS_FOR_SIGNATURE = Arrays.asList("Content-MD5".toLowerCase(), "Date".toLowerCase(), "X-Digipost-UserId".toLowerCase());

    public static String getCanonicalRequestRepresentation(RequestToSign request) {
        StringBuilder s = new StringBuilder();
        s.append(MessageSignatureUtil.getCanonicalMethodRepresentation(request));
        s.append(MessageSignatureUtil.getCanonicalUrlRepresentation(request));
        s.append(MessageSignatureUtil.getCanonicalHeaderRepresentation(request));
        s.append(MessageSignatureUtil.getCanonicalParameterRepresentation(request));
        return s.toString();
    }

    private static String getCanonicalMethodRepresentation(RequestToSign request) {
        return request.getMethod().toUpperCase() + "\n";
    }

    private static String getCanonicalUrlRepresentation(RequestToSign request) {
        return request.getPath().toLowerCase() + "\n";
    }

    private static String getCanonicalHeaderRepresentation(RequestToSign request) {
        SortedMap<String, String> headers = request.getHeaders();
        StringBuilder headersString = new StringBuilder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (!MessageSignatureUtil.isHeaderForSignature(key)) continue;
            headersString.append(key.toLowerCase() + ": " + entry.getValue() + "\n");
        }
        return headersString.toString();
    }

    private static String getCanonicalParameterRepresentation(RequestToSign request) {
        return request.getParameters().toLowerCase() + "\n";
    }

    private static boolean isHeaderForSignature(String key) {
        return HEADERS_FOR_SIGNATURE.contains(key.toLowerCase());
    }
}

