/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.convert.FromString;
import org.joda.convert.JDKStringConverter;
import org.joda.convert.MethodConstructorStringConverter;
import org.joda.convert.MethodsStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringConvert {
    public static final StringConvert INSTANCE = new StringConvert();
    private final ConcurrentMap<Class<?>, StringConverter<?>> registered = new ConcurrentHashMap();

    public StringConvert() {
        this(true);
    }

    public StringConvert(boolean bl) {
        if (bl) {
            for (JDKStringConverter jDKStringConverter : JDKStringConverter.values()) {
                this.registered.put(jDKStringConverter.getType(), jDKStringConverter);
            }
        }
    }

    public <T> String convertToString(T t) {
        if (t == null) {
            return null;
        }
        Class<?> clazz = t.getClass();
        StringConverter<?> stringConverter = this.findConverter(clazz);
        return stringConverter.convertToString(t);
    }

    public <T> T convertFromString(Class<T> clazz, String string) {
        if (string == null) {
            return null;
        }
        StringConverter<T> stringConverter = this.findConverter(clazz);
        return stringConverter.convertFromString(clazz, string);
    }

    public <T> StringConverter<T> findConverter(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        StringConverter stringConverter = (StringConverter)this.registered.get(clazz);
        if (stringConverter == null) {
            if (clazz == Object.class) {
                throw new IllegalStateException("No registered converter found: " + clazz);
            }
            for (Class<T> clazz2 = clazz.getSuperclass(); clazz2 != Object.class && stringConverter == null; clazz2 = clazz2.getSuperclass()) {
                stringConverter = (StringConverter)this.registered.get(clazz2);
            }
            if (stringConverter == null && (stringConverter = this.findAnnotationConverter(clazz)) == null) {
                throw new IllegalStateException("No registered converter found: " + clazz);
            }
            this.registered.putIfAbsent(clazz, stringConverter);
        }
        return stringConverter;
    }

    private <T> StringConverter<T> findAnnotationConverter(Class<T> clazz) {
        Method method = this.findToStringMethod(clazz);
        if (method == null) {
            return null;
        }
        Constructor<T> constructor = this.findFromStringConstructor(clazz);
        Method method2 = this.findFromStringMethod(clazz, constructor == null);
        if (constructor == null && method2 == null) {
            throw new IllegalStateException("Class annotated with @ToString but not with @FromString");
        }
        if (constructor != null && method2 != null) {
            throw new IllegalStateException("Both method and constructor are annotated with @FromString");
        }
        if (constructor != null) {
            return new MethodConstructorStringConverter<T>(clazz, method, constructor);
        }
        return new MethodsStringConverter<T>(clazz, method, method2);
    }

    private Method findToStringMethod(Class<?> clazz) {
        Method method = null;
        for (Class<?> clazz2 = clazz; clazz2 != Object.class && method == null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            for (Method method2 : methodArray = clazz2.getDeclaredMethods()) {
                ToString toString = method2.getAnnotation(ToString.class);
                if (toString == null) continue;
                if (method != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString");
                }
                method = method2;
            }
        }
        return method;
    }

    private <T> Constructor<T> findFromStringConstructor(Class<T> clazz) {
        try {
            Constructor<FromString> constructor = clazz.getDeclaredConstructor(String.class);
            FromString fromString = constructor.getAnnotation(FromString.class);
            return fromString != null ? constructor : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Method findFromStringMethod(Class<?> clazz, boolean bl) {
        Method method = null;
        for (Class<?> clazz2 = clazz; clazz2 != Object.class && method == null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            for (Method method2 : methodArray = clazz2.getDeclaredMethods()) {
                FromString fromString = method2.getAnnotation(FromString.class);
                if (fromString == null) continue;
                if (method != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString");
                }
                method = method2;
            }
            if (!bl) break;
        }
        return method;
    }

    public <T> void register(Class<T> clazz, StringConverter<T> stringConverter) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (stringConverter == null) {
            throw new IllegalArgumentException("StringConverter must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        StringConverter<T> stringConverter2 = this.registered.putIfAbsent(clazz, stringConverter);
        if (stringConverter2 != null) {
            throw new IllegalStateException("Converter already registered for class: " + clazz);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

