/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.ErrorType;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.representations.ContentType;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.MessageStatus;

public class MessageSender
extends Communicator {
    public MessageSender(ApiService apiService, EventLogger eventLogger) {
        super(apiService, eventLogger);
    }

    public MessageDelivery sendMessage(Message message, InputStream letterContent, ContentType contentType) {
        return this.sendMessage(message, letterContent, contentType, letterContent);
    }

    public MessageDelivery sendMessage(Message message, InputStream letterContent, ContentType contentType, InputStream printContent) {
        MessageDelivery delivery;
        ContentType finalContentType;
        InputStream unencryptetContent;
        this.log("\n\n---STARTER INTERAKSJON MED API: OPPRETTE FORSENDELSE---");
        MessageDelivery createdMessage = this.createOrFetchMessage(message);
        if (createdMessage.isDeliveredToDigipost()) {
            unencryptetContent = letterContent;
            finalContentType = contentType;
        } else {
            unencryptetContent = printContent;
            finalContentType = ContentType.PDF;
        }
        if (message.isPreEncrypt()) {
            this.log("\n\n---FORSENDELSE SKAL PREKRYPTERES, STARTER INTERAKSJON MED API: HENT PUBLIC KEY---");
            InputStream encryptetContent = this.fetchKeyAndEncrypt(createdMessage, unencryptetContent);
            delivery = this.uploadContent(finalContentType, createdMessage, encryptetContent);
        } else {
            delivery = this.uploadContent(finalContentType, createdMessage, unencryptetContent);
        }
        this.log("\n\n---API-INTERAKSJON ER FULLF\u00d8RT (OG BREVET ER DERMED SENDT)---");
        return delivery;
    }

    private MessageDelivery uploadContent(ContentType contentType, MessageDelivery createdMessage, InputStream unencryptetContent) {
        this.log("\n\n---STARTER INTERAKSJON MED API: LEGGE TIL FIL---");
        return this.addToContentAndSendMessage(createdMessage, unencryptetContent, contentType);
    }

    public MessageDelivery createOrFetchMessage(Message message) {
        ClientResponse response = this.apiService.createMessage(message);
        if (this.messageAlreadyExists(response)) {
            ClientResponse existingMessageResponse = this.apiService.fetchExistingMessage(response.getLocation());
            this.checkResponse(existingMessageResponse);
            MessageDelivery delivery = (MessageDelivery)existingMessageResponse.getEntity(MessageDelivery.class);
            this.checkThatExistingMessageIsIdenticalToNewMessage(delivery, message);
            this.checkThatMessageHasNotAlreadyBeenDelivered(delivery);
            this.log("Identisk forsendelse fantes fra f\u00f8r. Bruker denne istedenfor \u00e5 opprette ny. Status: [" + response.toString() + "]");
            return delivery;
        }
        this.check404Error(response, ErrorType.RECIPIENT_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Forsendelse opprettet. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(MessageDelivery.class);
    }

    public MessageDelivery addToContentAndSendMessage(MessageDelivery delivery, InputStream letterContent, ContentType contentType) {
        this.verifyCorrectStatus(delivery, MessageStatus.NOT_COMPLETE);
        ClientResponse response = this.apiService.addToContentAndSend(delivery, letterContent, contentType);
        this.check404Error(response, ErrorType.MESSAGE_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Innhold ble lagt til og brevet sendt. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(delivery.getClass());
    }

    private void checkThatMessageHasNotAlreadyBeenDelivered(MessageDelivery existingMessage) {
        switch (existingMessage.getStatus()) {
            case DELIVERED: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til mottaker den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveredDate());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorType.DIGIPOST_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
            case DELIVERED_TO_PRINT: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til print den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveredDate());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorType.PRINT_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
        }
    }

    protected void verifyCorrectStatus(MessageDelivery createdMessage, MessageStatus expectedStatus) {
        if (createdMessage.getStatus() != expectedStatus) {
            throw new DigipostClientException(ErrorType.INVALID_TRANSACTION, "Kan ikke legge til innhold til en forsendelse som ikke er i tilstanden " + (Object)((Object)expectedStatus) + ".");
        }
    }
}

