/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="sensitivity-level")
@XmlEnum
public enum SensitivityLevel {
    NORMAL(0),
    SENSITIVE(1);

    private final int level;

    private SensitivityLevel(int level) {
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public static SensitivityLevel fromLevel(int verdi) {
        switch (verdi) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return SENSITIVE;
            }
        }
        throw new IllegalArgumentException("Unknown sensitivity level: " + verdi);
    }

    public String value() {
        return this.name();
    }

    public static SensitivityLevel fromValue(String v) {
        return SensitivityLevel.valueOf(v);
    }
}

