/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.DigipostClientServerException;
import no.digipost.api.client.ErrorType;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.representations.Attachment;
import no.digipost.api.client.representations.EncryptionKey;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Communicator {
    private static final Logger LOG = LoggerFactory.getLogger(Communicator.class);
    protected final EventLogger eventLogger;
    protected final ApiService apiService;

    public Communicator(ApiService apiService, EventLogger eventLogger) {
        this.apiService = apiService;
        this.eventLogger = eventLogger;
    }

    private static OutputEncryptor buildEncryptor() throws CMSException {
        return new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider(BouncyCastleProvider.PROVIDER_NAME).build();
    }

    private byte[] preencrypt(byte[] data, String keyId, String keyContent) throws Exception {
        PEMReader reader = new PEMReader((Reader)new StringReader(keyContent));
        X509EncodedKeySpec spec = new X509EncodedKeySpec(((BCRSAPublicKey)reader.readObject()).getEncoded());
        IOUtils.closeQuietly((Reader)reader);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(spec);
        CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();
        gen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(keyId.getBytes(), publicKey));
        CMSEnvelopedData d = gen.generate((CMSTypedData)new CMSProcessableByteArray(data), Communicator.buildEncryptor());
        return d.getEncoded();
    }

    protected void checkResponse(ClientResponse response) {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (!this.responseOk(response)) {
            String errorMessage = this.fetchErrorMessageString(response);
            this.log(errorMessage);
            switch (status) {
                case BAD_REQUEST: {
                    throw new DigipostClientException(ErrorType.PROBLEM_WITH_REQUEST, errorMessage);
                }
                case CONFLICT: {
                    throw new DigipostClientException(ErrorType.INVALID_TRANSACTION, errorMessage);
                }
                case INTERNAL_SERVER_ERROR: {
                    throw new DigipostClientException(ErrorType.SERVER_ERROR, errorMessage);
                }
            }
            throw new DigipostClientException(ErrorType.GENERAL_ERROR, errorMessage);
        }
    }

    protected String fetchErrorMessageString(ClientResponse response) {
        try {
            return ((ErrorMessage)response.getEntity(ErrorMessage.class)).getErrorMessage();
        }
        catch (ClientHandlerException e) {
            return "Det skjedde en feil p\u00e5 serveren, men klienten kunne ikke lese responsen.";
        }
        catch (WebApplicationException spe) {
            return "Det skjedde en feil p\u00e5 serveren, men klienten kunne ikke lese responsen.";
        }
        catch (UniformInterfaceException e) {
            return "";
        }
    }

    private boolean responseOk(ClientResponse response) {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (status == null) {
            return false;
        }
        switch (status) {
            case CREATED: 
            case OK: {
                return true;
            }
        }
        return false;
    }

    protected void log(String message) {
        LOG.debug(message);
        this.eventLogger.log(message);
    }

    protected void logThrowable(Throwable t) {
        LOG.debug("Feil.", t);
        StringWriter stacktrace = new StringWriter();
        t.printStackTrace(new PrintWriter(stacktrace));
        this.eventLogger.log(stacktrace.toString());
    }

    protected boolean resourceAlreadyExists(ClientResponse response) {
        return Response.Status.CONFLICT.equals((Object)Response.Status.fromStatusCode((int)response.getStatus()));
    }

    protected void checkThatExistingMessageIsIdenticalToNewMessage(MessageDelivery exisitingMessage, Message message) {
        if (!exisitingMessage.isSameMessageAs(message)) {
            String errorMessage = "Forsendelse med id [" + message.getMessageId() + "] finnes fra f\u00f8r med annen spesifikasjon.";
            this.log(errorMessage);
            throw new DigipostClientException(ErrorType.DUPLICATE_MESSAGE_ID, errorMessage);
        }
    }

    protected void checkThatExistingAttachmentIsIdenticalToNewAttachment(Attachment exisitingAttachment, Attachment attachment) {
        if (!exisitingAttachment.isSameAttachmentAs(attachment)) {
            String errorMessage = "Vedlegg med emne [" + attachment.getSubject() + "] finnes fra f\u00f8r med annen spesifikasjon.";
            this.log(errorMessage);
            throw new DigipostClientException(ErrorType.DUPLICATE_MESSAGE_ID, errorMessage);
        }
    }

    protected void checkThatMessageCanBePreEncrypted(MessageDelivery delivery) {
        Link encryptionKeyLink = delivery.getEncryptionKeyLink();
        if (encryptionKeyLink == null) {
            String errorMessage = "Forsendelse med id [" + delivery.getMessageId() + "] kan ikke prekrypteres.";
            this.log(errorMessage);
            throw new DigipostClientException(ErrorType.CANNOT_PREENCRYPT, errorMessage);
        }
    }

    public InputStream fetchKeyAndEncrypt(MessageDelivery delivery, InputStream content) {
        this.checkThatMessageCanBePreEncrypted(delivery);
        ClientResponse encryptionKeyResponse = this.apiService.getEncryptionKey(delivery.getEncryptionKeyLink().getUri());
        this.checkResponse(encryptionKeyResponse);
        EncryptionKey key = (EncryptionKey)encryptionKeyResponse.getEntity(EncryptionKey.class);
        try {
            byte[] encryptedContent = this.preencrypt(IOUtils.toByteArray((InputStream)content), key.getKeyId(), key.getValue());
            return new ByteArrayInputStream(encryptedContent);
        }
        catch (Exception e) {
            this.logThrowable(e);
            throw new DigipostClientException(ErrorType.FAILED_PREENCRYPTION, "Inneholdet kunne ikke prekrypteres.");
        }
    }

    protected void check404Error(ClientResponse response, ErrorType errorBy404) {
        if (Response.Status.fromStatusCode((int)response.getStatus()) == Response.Status.NOT_FOUND) {
            throw new DigipostClientServerException(errorBy404, this.fetchErrorMessageEntity(response));
        }
    }

    private ErrorMessage fetchErrorMessageEntity(ClientResponse response) {
        return (ErrorMessage)response.getEntity(ErrorMessage.class);
    }
}

