/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="attachment", propOrder={"subject", "fileType", "links"})
@XmlRootElement(name="attachment")
public class Attachment
extends Representation {
    @XmlElement(name="subject", required=true)
    protected String subject;
    @XmlElement(name="file-type", required=true)
    protected String fileType;

    public Attachment() {
    }

    public Attachment(String subject, FileType fileType) {
        this.subject = subject;
        this.fileType = fileType.toString();
    }

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    protected void setLinks(List<Link> links) {
        this.links = links;
    }

    public String getSubject() {
        return this.subject;
    }

    public Link getSelfLink() {
        return this.getLinkByRelationName(Relation.SELF);
    }

    public Link getAddContentLink() {
        return this.getLinkByRelationName(Relation.ADD_CONTENT);
    }

    public boolean isSameAttachmentAs(Attachment attachment) {
        return this.subject.equals(attachment.getSubject());
    }

    public FileType getFileType() {
        return new FileType(this.fileType);
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType.toString();
    }
}

