/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.AuthenticationLevel;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;
import no.digipost.api.client.representations.RecipientIdentification;
import no.digipost.api.client.representations.SensitivityLevel;
import no.digipost.api.client.representations.SmsNotification;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message", propOrder={"messageId", "senderId", "preEncrypt", "subject", "recipient", "smsNotification", "authenticationLevel", "sensitivityLevel", "fileType"})
@XmlRootElement(name="message")
public class Message {
    @XmlElement(name="message-id", required=true)
    protected String messageId;
    @XmlElement(name="sender-id")
    protected Long senderId;
    @XmlElement(name="pre-encrypt")
    protected Boolean preEncrypt;
    @XmlElement(required=true)
    protected String subject;
    @XmlElement(name="recipient")
    protected RecipientIdentification recipient;
    @XmlElement(name="sms-notification")
    protected SmsNotification smsNotification;
    @XmlElement(name="authentication-level")
    protected AuthenticationLevel authenticationLevel;
    @XmlElement(name="sensitivity-level")
    protected SensitivityLevel sensitivityLevel;
    @XmlElement(name="file-type", required=true)
    protected String fileType;

    Message() {
    }

    public Message(String messageId, String subject, PersonalIdentificationNumber id, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType fileType) {
        this(messageId, subject, new RecipientIdentification(id), smsVarsling, authenticationLevel, sensitivityLevel, fileType);
    }

    public Message(String messageId, String subject, OrganisationNumber id, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType fileType) {
        this(messageId, subject, new RecipientIdentification(id), smsVarsling, authenticationLevel, sensitivityLevel, fileType);
    }

    public Message(String messageId, String subject, DigipostAddress digipostAdress, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType fileType) {
        this(messageId, subject, new RecipientIdentification(digipostAdress), smsVarsling, authenticationLevel, sensitivityLevel, fileType);
    }

    public Message(String messageId, String subject, NameAndAddress nameAndAddress, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType fileType) {
        this(messageId, subject, new RecipientIdentification(nameAndAddress), smsVarsling, authenticationLevel, sensitivityLevel, fileType);
    }

    public Message(String messageId, String subject, RecipientIdentification recipient, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType fileType) {
        this.messageId = messageId;
        this.subject = subject;
        this.recipient = recipient;
        this.smsNotification = smsVarsling;
        this.authenticationLevel = authenticationLevel;
        this.sensitivityLevel = sensitivityLevel;
        this.fileType = fileType.toString();
    }

    public Message(String messageId, PrintDetails printDetails) {
        this(messageId, null, new RecipientIdentification(printDetails), null, null, null, FileType.PDF);
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean hasSubject() {
        return !StringUtils.isBlank((String)this.subject);
    }

    public SmsNotification getSmsNotification() {
        return this.smsNotification;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public SensitivityLevel getSensitivityLevel() {
        return this.sensitivityLevel;
    }

    public RecipientIdentification getRecipient() {
        return this.recipient;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean isPreEncrypt() {
        return this.preEncrypt != null && this.preEncrypt != false;
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId.equals(message.getMessageId());
    }

    public void setPreEncrypt() {
        this.preEncrypt = true;
    }

    public void setSenderId(long senderId) {
        this.senderId = senderId;
    }

    public void setPreEncrypt(boolean preEncrypt) {
        this.preEncrypt = preEncrypt;
    }

    public boolean isDirectPrint() {
        return this.recipient.isDirectPrint();
    }

    public FileType getFileType() {
        return new FileType(this.fileType);
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType.toString();
    }
}

