/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.representations.Attachment;
import no.digipost.api.client.representations.AuthenticationLevel;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.NorwegianAddress;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;
import no.digipost.api.client.representations.PrintRecipient;
import no.digipost.api.client.representations.RecipientIdentification;
import no.digipost.api.client.representations.SensitivityLevel;
import no.digipost.api.client.representations.SmsNotification;
import org.apache.commons.io.FileUtils;
import org.joda.time.LocalDate;

public class DigipostSwingClient {
    private MessageDelivery messageDelivery = null;
    private static final String BREV = "BREV";
    private static final String CERT = "CERT";
    private JFrame frmDigipostApiClient;
    private JTextField certField;
    private JPasswordField passwordField;
    private JTextField senderField;
    private JTextField subjectField;
    private JTextField recipientDigipostAddressField;
    private JTextField recipientPersonalIdentificationNumberField;
    private JTextField recipientNameField;
    private JTextField recipientAddress1Field;
    private JTextField recipientAddress2Field;
    private JTextField recipientPostalcodeField;
    private JTextField recipientCityField;
    private JTextField recipientBirthDateField;
    private JTextField recipientPhoneNumberField;
    private JTextField recipientEmailAddressField;
    private JCheckBox fallbackToPrintCheckBox;
    private JCheckBox directToPrintCheckBox;
    private JTextField attachmentSubjectField;
    private JTextField attachmentContentField;
    private JButton addAttachmentContentButton;
    private JButton btnAddAttachment;
    private JButton sendButton;
    private JTextField contentField;
    private JTextArea logTextArea;
    private DigipostClient client;
    private final EventLogger eventLogger = new EventLogger(){

        @Override
        public void log(String logMesssage) {
            DigipostSwingClient.this.logTextArea.append(logMesssage + "\n");
        }
    };
    private JTextField endpointField;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DigipostSwingClient window = new DigipostSwingClient();
                    window.frmDigipostApiClient.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public DigipostSwingClient() {
        this.initialize();
    }

    private void initialize() {
        this.frmDigipostApiClient = new JFrame();
        this.frmDigipostApiClient.setTitle("Digipost API Client");
        this.frmDigipostApiClient.setSize(768, 768);
        this.frmDigipostApiClient.setDefaultCloseOperation(3);
        this.frmDigipostApiClient.setLocationRelativeTo(null);
        final JPanel contentPane = new JPanel();
        contentPane.setLayout(new CardLayout(0, 0));
        final JPanel brevPanel = new JPanel();
        brevPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)brevPanel, BREV);
        brevPanel.setLayout(new BorderLayout(0, 0));
        JPanel brevTopPanel = new JPanel();
        brevTopPanel.setBorder(new EmptyBorder(0, 0, 20, 0));
        brevPanel.add((Component)brevTopPanel, "North");
        brevTopPanel.setLayout(new BorderLayout(0, 0));
        JPanel brevHelpPanel = new JPanel();
        brevHelpPanel.setBorder(new EmptyBorder(0, 0, 20, 0));
        brevTopPanel.add((Component)brevHelpPanel, "North");
        brevHelpPanel.setLayout(new BorderLayout(0, 0));
        JLabel steg2Label = new JLabel("Steg 2: Lag og send brev.");
        steg2Label.setFont(new Font("Dialog", 1, 16));
        brevHelpPanel.add((Component)steg2Label, "North");
        JLabel steg2SubLabel = new JLabel("<html><br>Her spesifiserer du selve forsendelsen du \u00f8nsker \u00e5 sende. <br><br>Fra dette eksempel-GUI-et kan du sende til en persons Digipost-adresse, f\u00f8dselsnummer eller navn og adresse. Ved sending til en persons navn og adresse kan du legge til tilleggsidentifikatorer (f\u00f8dselsdato og epost-adresse eller telefonnummer) og velge \u00e5 sende med fallback til print eller direkte til print.</html>");
        brevHelpPanel.add((Component)steg2SubLabel, "South");
        JPanel brevMainPanel = new JPanel();
        brevTopPanel.add((Component)brevMainPanel, "South");
        GridBagLayout gbl_brevMainPanel = new GridBagLayout();
        gbl_brevMainPanel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_brevMainPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_brevMainPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_brevMainPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        brevMainPanel.setLayout(gbl_brevMainPanel);
        JLabel emneLabel = new JLabel("Brev-emne");
        brevMainPanel.add((Component)emneLabel, this.createGridBagConstraintsForLabel(0, 0));
        this.subjectField = new JTextField();
        brevMainPanel.add((Component)this.subjectField, this.createGridBagConstraintsForField(1, 0));
        this.subjectField.setColumns(10);
        JLabel mottakerLabel = new JLabel("Mottakers digipostadresse");
        brevMainPanel.add((Component)mottakerLabel, this.createGridBagConstraintsForLabel(0, 1));
        this.recipientDigipostAddressField = new JTextField();
        brevMainPanel.add((Component)this.recipientDigipostAddressField, this.createGridBagConstraintsForField(1, 1));
        this.recipientDigipostAddressField.setColumns(10);
        final JRadioButton identifyOnDigipostAddress = new JRadioButton();
        identifyOnDigipostAddress.setSelected(true);
        brevMainPanel.add((Component)identifyOnDigipostAddress, this.createGridBagConstraintsForRadioButton(5, 1));
        identifyOnDigipostAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DigipostSwingClient.this.enableDigipostAddressFields();
            }
        });
        JLabel mottakerFoedselsnummerLabel = new JLabel("Mottakers f\u00f8dselsnummer");
        brevMainPanel.add((Component)mottakerFoedselsnummerLabel, this.createGridBagConstraintsForLabel(0, 2));
        this.recipientPersonalIdentificationNumberField = new JTextField();
        this.recipientPersonalIdentificationNumberField.setEnabled(false);
        brevMainPanel.add((Component)this.recipientPersonalIdentificationNumberField, this.createGridBagConstraintsForField(1, 2));
        this.recipientPersonalIdentificationNumberField.setColumns(10);
        final JRadioButton identifyOnPersonalIdentificationNumber = new JRadioButton();
        brevMainPanel.add((Component)identifyOnPersonalIdentificationNumber, this.createGridBagConstraintsForRadioButton(5, 2));
        identifyOnPersonalIdentificationNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DigipostSwingClient.this.enablePersonalIdentificationNumberFields();
            }
        });
        JLabel mottakerNavnLabel = new JLabel("Mottakers navn");
        brevMainPanel.add((Component)mottakerNavnLabel, this.createGridBagConstraintsForLabel(0, 3));
        this.recipientNameField = new JTextField();
        this.recipientNameField.setEnabled(false);
        brevMainPanel.add((Component)this.recipientNameField, this.createGridBagConstraintsForField(1, 3));
        this.recipientNameField.setColumns(10);
        JRadioButton identifyOnNameAndAddress = new JRadioButton();
        brevMainPanel.add((Component)identifyOnNameAndAddress, this.createGridBagConstraintsForField(5, 3));
        identifyOnNameAndAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DigipostSwingClient.this.enableNameAndAddressFields();
            }
        });
        ButtonGroup identifierGroup = new ButtonGroup();
        identifierGroup.add(identifyOnDigipostAddress);
        identifierGroup.add(identifyOnNameAndAddress);
        identifierGroup.add(identifyOnPersonalIdentificationNumber);
        JLabel mottakerAdresse1Label = new JLabel("Adresselinje 1");
        brevMainPanel.add((Component)mottakerAdresse1Label, this.createGridBagConstraintsForLabel(0, 4));
        this.recipientAddress1Field = new JTextField();
        this.recipientAddress1Field.setEnabled(false);
        brevMainPanel.add((Component)this.recipientAddress1Field, this.createGridBagConstraintsForField(1, 4));
        this.recipientAddress1Field.setColumns(10);
        JLabel mottakerAdresse2Label = new JLabel("Adresselinje 2");
        brevMainPanel.add((Component)mottakerAdresse2Label, this.createGridBagConstraintsForLabel(0, 5));
        this.recipientAddress2Field = new JTextField();
        this.recipientAddress2Field.setEnabled(false);
        brevMainPanel.add((Component)this.recipientAddress2Field, this.createGridBagConstraintsForField(1, 5));
        this.recipientAddress2Field.setColumns(10);
        JLabel mottakerPostnummerLabel = new JLabel("Postnummer");
        brevMainPanel.add((Component)mottakerPostnummerLabel, this.createGridBagConstraintsForLabel(0, 6));
        this.recipientPostalcodeField = new JTextField();
        this.recipientPostalcodeField.setEnabled(false);
        brevMainPanel.add((Component)this.recipientPostalcodeField, this.createGridBagConstraintsForField(1, 6, 1));
        this.recipientPostalcodeField.setColumns(10);
        JLabel mottakerPoststedLabel = new JLabel("Poststed");
        brevMainPanel.add((Component)mottakerPoststedLabel, this.createGridBagConstraintsForLabel(2, 6));
        this.recipientCityField = new JTextField();
        this.recipientCityField.setEnabled(false);
        brevMainPanel.add((Component)this.recipientCityField, this.createGridBagConstraintsForField(3, 6, 1));
        this.recipientCityField.setColumns(10);
        JLabel mottakerFoedselsdatoLabel = new JLabel("F\u00f8dselsdato (DD.MM.YYYY)");
        brevMainPanel.add((Component)mottakerFoedselsdatoLabel, this.createGridBagConstraintsForLabel(0, 7));
        this.recipientBirthDateField = new JTextField();
        this.recipientBirthDateField.setEnabled(false);
        brevMainPanel.add((Component)this.recipientBirthDateField, this.createGridBagConstraintsForField(1, 7, 1));
        this.recipientBirthDateField.setColumns(10);
        JLabel mottakerTelefonnummerLabel = new JLabel("Telefonnummer");
        brevMainPanel.add((Component)mottakerTelefonnummerLabel, this.createGridBagConstraintsForLabel(2, 7));
        this.recipientPhoneNumberField = new JTextField();
        this.recipientPhoneNumberField.setEnabled(false);
        brevMainPanel.add((Component)this.recipientPhoneNumberField, this.createGridBagConstraintsForField(3, 7, 1));
        this.recipientPhoneNumberField.setColumns(10);
        JLabel mottakerEpostadresseLabel = new JLabel("Epost-adresse");
        brevMainPanel.add((Component)mottakerEpostadresseLabel, this.createGridBagConstraintsForLabel(0, 8));
        this.recipientEmailAddressField = new JTextField();
        this.recipientEmailAddressField.setEnabled(false);
        brevMainPanel.add((Component)this.recipientEmailAddressField, this.createGridBagConstraintsForField(1, 8));
        this.recipientEmailAddressField.setColumns(10);
        JLabel fallbackToPrintLabel = new JLabel("Fallback til print");
        brevMainPanel.add((Component)fallbackToPrintLabel, this.createGridBagConstraintsForLabel(0, 9));
        this.fallbackToPrintCheckBox = new JCheckBox();
        this.fallbackToPrintCheckBox.setEnabled(false);
        brevMainPanel.add((Component)this.fallbackToPrintCheckBox, this.createGridBagConstraintsForField(1, 9, 1));
        JLabel directToPrintLabel = new JLabel("Direkte til print");
        brevMainPanel.add((Component)directToPrintLabel, this.createGridBagConstraintsForLabel(2, 9));
        this.directToPrintCheckBox = new JCheckBox();
        this.directToPrintCheckBox.setEnabled(false);
        brevMainPanel.add((Component)this.directToPrintCheckBox, this.createGridBagConstraintsForField(3, 9, 1));
        JLabel innholdLabel = new JLabel("Brevets innhold");
        brevMainPanel.add((Component)innholdLabel, this.createGridBagConstraintsForLabel(0, 10));
        this.contentField = new JTextField();
        brevMainPanel.add((Component)this.contentField, this.createGridBagConstraintsForField(1, 10));
        this.contentField.setColumns(10);
        JButton velgInnholdButton = new JButton("Velg...");
        velgInnholdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser filChooser = new JFileChooser();
                filChooser.showOpenDialog(brevPanel);
                File filFile = filChooser.getSelectedFile();
                if (filFile != null) {
                    DigipostSwingClient.this.contentField.setText(filFile.toString());
                }
            }
        });
        brevMainPanel.add((Component)velgInnholdButton, this.createGridBagConstraints(17, 5, 10));
        JLabel vedleggTittelLabel = new JLabel("Vedlegg-emne");
        brevMainPanel.add((Component)vedleggTittelLabel, this.createGridBagConstraintsForLabel(0, 11));
        this.attachmentSubjectField = new JTextField();
        this.attachmentSubjectField.setEnabled(false);
        brevMainPanel.add((Component)this.attachmentSubjectField, this.createGridBagConstraintsForField(1, 11, 1));
        this.attachmentSubjectField.setColumns(10);
        JLabel vedleggInnholdLabel = new JLabel("Vedlegg-innhold");
        brevMainPanel.add((Component)vedleggInnholdLabel, this.createGridBagConstraintsForLabel(2, 11));
        this.attachmentContentField = new JTextField();
        this.attachmentContentField.setEnabled(false);
        brevMainPanel.add((Component)this.attachmentContentField, this.createGridBagConstraintsForField(3, 11, 1));
        this.attachmentContentField.setColumns(10);
        this.addAttachmentContentButton = new JButton("Velg...");
        this.addAttachmentContentButton.setEnabled(false);
        this.addAttachmentContentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser filChooser = new JFileChooser();
                filChooser.showOpenDialog(brevPanel);
                File filFile = filChooser.getSelectedFile();
                if (filFile != null) {
                    DigipostSwingClient.this.attachmentContentField.setText(filFile.toString());
                }
            }
        });
        brevMainPanel.add((Component)this.addAttachmentContentButton, this.createGridBagConstraints(17, 5, 11));
        JButton btnBack = new JButton("Tilbake");
        btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardLayout layout = (CardLayout)contentPane.getLayout();
                layout.show(contentPane, DigipostSwingClient.CERT);
            }
        });
        GridBagConstraints gbc_btnBack = new GridBagConstraints();
        gbc_btnBack.gridx = 0;
        gbc_btnBack.gridy = 12;
        brevMainPanel.add((Component)btnBack, gbc_btnBack);
        this.btnAddAttachment = new JButton("Legg til vedlegg");
        this.btnAddAttachment.setEnabled(false);
        this.btnAddAttachment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DigipostSwingClient.this.messageDelivery == null) {
                    DigipostSwingClient.this.eventLogger.log("Du m\u00e5 opprette og laste opp innhold til en forsendelse f\u00f8r du kan legge til vedlegg.");
                    return;
                }
                try {
                    String subject = DigipostSwingClient.this.attachmentSubjectField.getText();
                    FileType fileType = FileType.fromFilename(DigipostSwingClient.this.attachmentContentField.getText());
                    Attachment attachment = new Attachment(subject, fileType);
                    DigipostSwingClient.this.client.createAttachment(DigipostSwingClient.this.messageDelivery, attachment, FileUtils.openInputStream((File)new File(DigipostSwingClient.this.attachmentContentField.getText())));
                }
                catch (IOException ex) {
                    DigipostSwingClient.this.eventLogger.log(ex.getMessage() + "\n");
                }
                catch (DigipostClientException ex) {
                    DigipostSwingClient.this.eventLogger.log("\nDigipostClient kastet exception. \nFeilkode: " + (Object)((Object)ex.getErrorType()) + "\nFeilmelding: " + ex.getErrorMessage());
                }
            }
        });
        GridBagConstraints gbc_btnAddAttachment = new GridBagConstraints();
        gbc_btnAddAttachment.gridx = 1;
        gbc_btnAddAttachment.gridy = 12;
        brevMainPanel.add((Component)this.btnAddAttachment, gbc_btnAddAttachment);
        JButton btnAddContent = new JButton("Opprett og last opp brev");
        btnAddContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Message message;
                    String subject = DigipostSwingClient.this.subjectField.getText();
                    FileType fileType = FileType.fromFilename(DigipostSwingClient.this.contentField.getText());
                    if (identifyOnDigipostAddress.isSelected()) {
                        String digipostAddress = DigipostSwingClient.this.recipientDigipostAddressField.getText();
                        message = new Message(String.valueOf(System.currentTimeMillis()), subject, new DigipostAddress(digipostAddress), new SmsNotification(), AuthenticationLevel.PASSWORD, SensitivityLevel.NORMAL, fileType);
                    } else if (identifyOnPersonalIdentificationNumber.isSelected()) {
                        String personalIdentificationNumber = DigipostSwingClient.this.recipientPersonalIdentificationNumberField.getText();
                        message = new Message(String.valueOf(System.currentTimeMillis()), subject, new PersonalIdentificationNumber(personalIdentificationNumber), new SmsNotification(), AuthenticationLevel.PASSWORD, SensitivityLevel.NORMAL, fileType);
                    } else {
                        PrintRecipient printRecipient;
                        String name = DigipostSwingClient.this.recipientNameField.getText();
                        String addressline1 = DigipostSwingClient.this.recipientAddress1Field.getText();
                        String addressline2 = DigipostSwingClient.this.recipientAddress2Field.getText().equals("") ? null : DigipostSwingClient.this.recipientAddress2Field.getText();
                        String zipCode = DigipostSwingClient.this.recipientPostalcodeField.getText();
                        String city = DigipostSwingClient.this.recipientCityField.getText();
                        String birthDateAsString = DigipostSwingClient.this.recipientBirthDateField.getText();
                        LocalDate birthDate = null;
                        if (!birthDateAsString.equals("")) {
                            birthDate = new LocalDate(Integer.parseInt(birthDateAsString.substring(6)), Integer.parseInt(birthDateAsString.substring(3, 5)), Integer.parseInt(birthDateAsString.substring(0, 2)));
                        }
                        String phoneNumber = DigipostSwingClient.this.recipientPhoneNumberField.getText().equals("") ? null : DigipostSwingClient.this.recipientPhoneNumberField.getText();
                        String emailAddress = DigipostSwingClient.this.recipientEmailAddressField.getText().equals("") ? null : DigipostSwingClient.this.recipientEmailAddressField.getText();
                        NameAndAddress nameAndAddress = new NameAndAddress(name, addressline1, addressline2, zipCode, city, birthDate, phoneNumber, emailAddress);
                        NorwegianAddress norwegianAddress = new NorwegianAddress(addressline1, addressline2, zipCode, city);
                        PrintRecipient returnAddress = printRecipient = new PrintRecipient(name, norwegianAddress);
                        PrintDetails printDetails = new PrintDetails(printRecipient, returnAddress, PrintDetails.PostType.B);
                        RecipientIdentification recipient = DigipostSwingClient.this.fallbackToPrintCheckBox.isSelected() ? new RecipientIdentification(nameAndAddress, printDetails) : (DigipostSwingClient.this.directToPrintCheckBox.isSelected() ? new RecipientIdentification(printDetails) : new RecipientIdentification(nameAndAddress));
                        message = new Message(String.valueOf(System.currentTimeMillis()), subject, recipient, new SmsNotification(), AuthenticationLevel.PASSWORD, SensitivityLevel.NORMAL, fileType);
                    }
                    DigipostSwingClient.this.messageDelivery = DigipostSwingClient.this.client.createMessage(message, FileUtils.openInputStream((File)new File(DigipostSwingClient.this.contentField.getText())));
                    DigipostSwingClient.this.enableAttachmentFields(true);
                    DigipostSwingClient.this.sendButton.setEnabled(true);
                }
                catch (IOException ex) {
                    DigipostSwingClient.this.eventLogger.log(ex.getMessage() + "\n");
                }
                catch (DigipostClientException ex) {
                    DigipostSwingClient.this.eventLogger.log("\nDigipostClient kastet exception. \nFeilkode: " + (Object)((Object)ex.getErrorType()) + "\nFeilmelding: " + ex.getErrorMessage());
                }
            }
        });
        GridBagConstraints gbc_btnAddContent = new GridBagConstraints();
        gbc_btnAddContent.gridx = 2;
        gbc_btnAddContent.gridy = 12;
        gbc_btnAddContent.gridwidth = 2;
        brevMainPanel.add((Component)btnAddContent, gbc_btnAddContent);
        this.sendButton = new JButton("Send brev");
        this.sendButton.setEnabled(false);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DigipostSwingClient.this.messageDelivery == null) {
                    DigipostSwingClient.this.eventLogger.log("Du m\u00e5 opprette og laste opp innhold til en forsendelse f\u00f8r den kan sendes.");
                    return;
                }
                DigipostSwingClient.this.client.sendMessage(DigipostSwingClient.this.messageDelivery);
                DigipostSwingClient.this.enableAttachmentFields(false);
                DigipostSwingClient.this.sendButton.setEnabled(false);
                DigipostSwingClient.this.messageDelivery = null;
            }
        });
        GridBagConstraints gbc_sendButton = new GridBagConstraints();
        gbc_sendButton.gridx = 5;
        gbc_sendButton.gridy = 12;
        brevMainPanel.add((Component)this.sendButton, gbc_sendButton);
        JPanel logPanel = new JPanel();
        brevPanel.add((Component)logPanel, "Center");
        logPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane logScroll = new JScrollPane();
        logPanel.add(logScroll);
        this.logTextArea = new JTextArea();
        this.logTextArea.setLineWrap(true);
        this.logTextArea.setWrapStyleWord(true);
        this.logTextArea.setEditable(false);
        logScroll.setViewportView(this.logTextArea);
        this.frmDigipostApiClient.setContentPane(contentPane);
        CardLayout layout = (CardLayout)contentPane.getLayout();
        layout.show(contentPane, CERT);
        JPanel velgCertPanel = new JPanel();
        velgCertPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)velgCertPanel, CERT);
        velgCertPanel.setLayout(new BorderLayout(0, 0));
        JPanel helpPanel = new JPanel();
        helpPanel.setBorder(new EmptyBorder(0, 0, 20, 0));
        velgCertPanel.add((Component)helpPanel, "North");
        helpPanel.setLayout(new BorderLayout(0, 0));
        JLabel steg1Label = new JLabel("Steg 1: Velg Sertifikat");
        steg1Label.setFont(new Font("Dialog", 1, 16));
        helpPanel.add(steg1Label);
        JLabel steg1SubLabel = new JLabel("<html><br>F\u00f8r du kan sende brev, m\u00e5 du laste inn sertifikatet som er knyttet til din virksomhets Digipost-konto. Dette m\u00e5 v\u00e6re p\u00e5 .p12-formatet. <br><br>Hvis dette er et Buypass-sertifikat, og du enda ikke har lastet det opp til Digipost, kan du gj\u00f8re dette p\u00e5 <a href='https://www.digipost.no/virksomhet'>https://www.digipost.no/virksomhet</a>. Les mer om dette i dokumentasjonen.</html>");
        helpPanel.add((Component)steg1SubLabel, "South");
        JPanel certPanel = new JPanel();
        velgCertPanel.add((Component)certPanel, "Center");
        GridBagLayout gbl_certPanel = new GridBagLayout();
        gbl_certPanel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_certPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_certPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_certPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        certPanel.setLayout(gbl_certPanel);
        JLabel certLabel = new JLabel("Sertifikatfil (.p12)");
        certPanel.add((Component)certLabel, this.createGridBagConstraintsForLabel(0, 0));
        this.certField = new JTextField();
        certPanel.add((Component)this.certField, this.createGridBagConstraintsForField(1, 0, 1));
        this.certField.setColumns(10);
        JButton certButton = new JButton("Velg...");
        certButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser filChooser = new JFileChooser();
                filChooser.showOpenDialog(brevPanel);
                File filFile = filChooser.getSelectedFile();
                if (filFile != null) {
                    DigipostSwingClient.this.certField.setText(filFile.toString());
                }
            }
        });
        GridBagConstraints gbc_certButton = new GridBagConstraints();
        gbc_certButton.insets = new Insets(0, 0, 5, 0);
        gbc_certButton.gridx = 2;
        gbc_certButton.gridy = 0;
        certPanel.add((Component)certButton, gbc_certButton);
        JLabel passordLabel = new JLabel("Sertifikatpassord");
        certPanel.add((Component)passordLabel, this.createGridBagConstraintsForLabel(0, 1));
        this.passwordField = new JPasswordField();
        certPanel.add((Component)this.passwordField, this.createGridBagConstraintsForField(1, 1, 1));
        this.passwordField.setColumns(10);
        JLabel avsenderLabel = new JLabel("Avsenders ID");
        certPanel.add((Component)avsenderLabel, this.createGridBagConstraintsForLabel(0, 2));
        this.senderField = new JTextField();
        certPanel.add((Component)this.senderField, this.createGridBagConstraintsForField(1, 2, 1));
        this.senderField.setColumns(10);
        JLabel endpointLabel = new JLabel("API-endpoint URL");
        certPanel.add((Component)endpointLabel, this.createGridBagConstraintsForLabel(0, 3));
        this.endpointField = new JTextField("https://api.digipost.no");
        certPanel.add((Component)this.endpointField, this.createGridBagConstraintsForField(1, 3, 1));
        this.endpointField.setColumns(10);
        JButton nesteButton = new JButton("Neste");
        nesteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardLayout layout = (CardLayout)contentPane.getLayout();
                layout.show(contentPane, DigipostSwingClient.BREV);
                DigipostSwingClient.this.turnOffEndpointSslValidationIfWeAreTargetingDigipostTestEnvironment(DigipostSwingClient.this.endpointField.getText());
                try {
                    DigipostSwingClient.this.client = new DigipostClient(DigipostSwingClient.this.endpointField.getText(), Long.parseLong(DigipostSwingClient.this.senderField.getText()), FileUtils.openInputStream((File)new File(DigipostSwingClient.this.certField.getText())), new String(DigipostSwingClient.this.passwordField.getPassword()), DigipostSwingClient.this.eventLogger);
                }
                catch (NumberFormatException e1) {
                    DigipostSwingClient.this.eventLogger.log("FEIL: Avsenders ID m\u00e5 v\u00e6re et tall > 0");
                }
                catch (IOException e1) {
                    DigipostSwingClient.this.eventLogger.log("FEIL: Klarte ikke \u00e5 lese sertifikatfil:\n" + e1);
                }
                catch (Exception e1) {
                    DigipostSwingClient.this.eventLogger.log("FEIL: Kunne ikke initialisere Digipost-API-klienten. Dette kan f.eks skyldes at sertifikatfilen var ugyldig, eller at du skrev inn feil passord. Feilmelding var:\n" + e1.getMessage());
                }
            }
        });
        Component verticalStrut = Box.createVerticalStrut(20);
        GridBagConstraints gbc_verticalStrut = new GridBagConstraints();
        gbc_verticalStrut.insets = new Insets(0, 0, 5, 0);
        gbc_verticalStrut.gridx = 2;
        gbc_verticalStrut.gridy = 4;
        certPanel.add(verticalStrut, gbc_verticalStrut);
        GridBagConstraints gbc_nesteButton = new GridBagConstraints();
        gbc_nesteButton.gridx = 2;
        gbc_nesteButton.gridy = 5;
        certPanel.add((Component)nesteButton, gbc_nesteButton);
        CardLayout l = (CardLayout)contentPane.getLayout();
        l.show(contentPane, CERT);
    }

    private void enableAttachmentFields(boolean enabled) {
        this.clearAttachmentFields();
        this.attachmentContentField.setEnabled(enabled);
        this.attachmentSubjectField.setEnabled(enabled);
        this.addAttachmentContentButton.setEnabled(enabled);
        this.btnAddAttachment.setEnabled(enabled);
    }

    private void clearAttachmentFields() {
        this.attachmentContentField.setText("");
        this.attachmentSubjectField.setText("");
    }

    private void enableDigipostAddressFields() {
        this.enableFields(true, false, false);
    }

    private void enablePersonalIdentificationNumberFields() {
        this.enableFields(false, true, false);
    }

    private void enableNameAndAddressFields() {
        this.enableFields(false, false, true);
    }

    private void enableFields(boolean digipostAddress, boolean personalIdentificationNumber, boolean nameAndAddress) {
        this.recipientDigipostAddressField.setEnabled(digipostAddress);
        this.recipientPersonalIdentificationNumberField.setEnabled(personalIdentificationNumber);
        this.recipientNameField.setEnabled(nameAndAddress);
        this.recipientAddress1Field.setEnabled(nameAndAddress);
        this.recipientAddress2Field.setEnabled(nameAndAddress);
        this.recipientPostalcodeField.setEnabled(nameAndAddress);
        this.recipientCityField.setEnabled(nameAndAddress);
        this.recipientBirthDateField.setEnabled(nameAndAddress);
        this.recipientPhoneNumberField.setEnabled(nameAndAddress);
        this.recipientEmailAddressField.setEnabled(nameAndAddress);
        this.fallbackToPrintCheckBox.setEnabled(nameAndAddress);
        this.directToPrintCheckBox.setEnabled(nameAndAddress);
    }

    private GridBagConstraints createGridBagConstraintsForField(int gridx, int gridy) {
        return this.createGridBagConstraintsForField(gridx, gridy, 3);
    }

    private GridBagConstraints createGridBagConstraintsForField(int gridx, int gridy, int gridwidth) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.fill = 2;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        return gbc;
    }

    private GridBagConstraints createGridBagConstraintsForRadioButton(int gridx, int gridy) {
        return this.createGridBagConstraints(17, gridx, gridy);
    }

    private GridBagConstraints createGridBagConstraintsForLabel(int gridx, int gridy) {
        return this.createGridBagConstraints(13, gridx, gridy);
    }

    private GridBagConstraints createGridBagConstraints(int anchor, int gridx, int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = anchor;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        return gbc;
    }

    private void turnOffEndpointSslValidationIfWeAreTargetingDigipostTestEnvironment(String endpoint) {
        if (endpoint.contains("camelon")) {
            this.eventLogger.log("Detekterte at vi g\u00e5r mot Digipost Testmilj\u00f8. Skrur derfor av SSL-sjekk");
            try {
                TrustManager[] noopTrustManager = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, noopTrustManager, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier noopHostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(noopHostnameVerifier);
            }
            catch (Exception e) {
                this.eventLogger.log("Klarte ikke \u00e5 skru av SSL-sjekk.");
                throw new RuntimeException(e);
            }
        }
    }
}

