/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.ApacheHttpClientHandler;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class JerseyClientProvider {
    private static final int MAX_HTTP_CONNECTIONS = 100;
    private static final Integer THREADPOOL_SIZE = 100;
    private static final Integer CONNECTION_TIMEOUT = 60000;
    private static final Integer READ_TIMEOUT = 60000;

    public static Client newClient() {
        ApacheHttpClientHandler clientHandler = new ApacheHttpClientHandler(JerseyClientProvider.opprettMultiThreadedHttpClient(), JerseyClientProvider.opprettClientConfig(CONNECTION_TIMEOUT, READ_TIMEOUT));
        return new ApacheHttpClient(clientHandler);
    }

    public static Client newClient(int connectionTimeout, int readTimout) {
        ApacheHttpClientHandler clientHandler = new ApacheHttpClientHandler(JerseyClientProvider.opprettMultiThreadedHttpClient(), JerseyClientProvider.opprettClientConfig(connectionTimeout, readTimout));
        return new ApacheHttpClient(clientHandler);
    }

    private static HttpClient opprettMultiThreadedHttpClient() {
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setMaxTotalConnections(100);
        params.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, 100);
        httpConnectionManager.setParams(params);
        return new HttpClient((HttpConnectionManager)httpConnectionManager);
    }

    private static ClientConfig opprettClientConfig(Integer connectionTimeout, Integer readTimeout) {
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        config.getProperties().put("com.sun.jersey.client.property.threadpoolSize", THREADPOOL_SIZE);
        config.getProperties().put("com.sun.jersey.client.property.connectTimeout", connectionTimeout);
        config.getProperties().put("com.sun.jersey.client.property.readTimeout", readTimeout);
        return config;
    }
}

