/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters;

import com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMD5Filter
extends ClientFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ContentMD5Filter.class);
    private final EventLogger eventLogger;

    public ContentMD5Filter(EventLogger eventListener) {
        this.eventLogger = eventListener != null ? eventListener : DigipostClient.NOOP_EVENT_LOGGER;
    }

    public ContentMD5Filter() {
        this(DigipostClient.NOOP_EVENT_LOGGER);
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        cr.setAdapter((ClientRequestAdapter)new ContentMD5Adapter(cr.getAdapter()));
        return this.getNext().handle(cr);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    private final class ContentMD5OutputStream
    extends OutputStream {
        private final ByteArrayOutputStream byteArrayOutputStream;
        private final OutputStream jerseyStream;
        private final ClientRequest request;

        public ContentMD5OutputStream(ClientRequest request, OutputStream jerseyStream) {
            this.jerseyStream = jerseyStream;
            this.request = request;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.byteArrayOutputStream.write(b);
        }

        @Override
        public void close() throws IOException {
            this.byteArrayOutputStream.close();
            byte[] byteArray = this.byteArrayOutputStream.toByteArray();
            this.settContentMD5Header(byteArray);
            IOUtils.write((byte[])byteArray, (OutputStream)this.jerseyStream);
            this.jerseyStream.close();
        }

        private void settContentMD5Header(byte[] data) {
            try {
                MessageDigest instance = MessageDigest.getInstance("MD5");
                String contentMD5 = new String(Base64.encodeBase64((byte[])instance.digest(data)));
                this.request.getHeaders().add((Object)"Content-MD5", (Object)contentMD5);
                ContentMD5Filter.this.log(ContentMD5Filter.class.getSimpleName() + " satt headeren " + "Content-MD5" + "=" + contentMD5);
            }
            catch (NoSuchAlgorithmException e) {
                ContentMD5Filter.this.log("Feil ved generering av Content-MD5");
            }
        }
    }

    private final class ContentMD5Adapter
    extends AbstractClientRequestAdapter {
        ContentMD5Adapter(ClientRequestAdapter cra) {
            super(cra);
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            return new ContentMD5OutputStream(request, this.getAdapter().adapt(request, out));
        }
    }
}

