/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.AuthenticationLevel;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;
import no.digipost.api.client.representations.RecipientIdentification;
import no.digipost.api.client.representations.SensitivityLevel;
import no.digipost.api.client.representations.SmsNotification;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message", propOrder={"uuid", "senderId", "preEncrypt", "subject", "recipient", "smsNotification", "authenticationLevel", "sensitivityLevel", "digipostFileType"})
@XmlRootElement(name="message")
public class Message {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    @XmlElement(name="uuid", required=true)
    protected String uuid;
    @XmlElement(name="sender-id")
    protected Long senderId;
    @XmlElement(name="pre-encrypt")
    protected Boolean preEncrypt;
    @XmlElement(required=true)
    protected String subject;
    @XmlElement(name="recipient")
    protected RecipientIdentification recipient;
    @XmlElement(name="sms-notification")
    protected SmsNotification smsNotification;
    @XmlElement(name="authentication-level")
    protected AuthenticationLevel authenticationLevel;
    @XmlElement(name="sensitivity-level")
    protected SensitivityLevel sensitivityLevel;
    @XmlElement(name="file-type", required=true)
    protected String digipostFileType;

    Message() {
    }

    public Message(String uuid, String subject, PersonalIdentificationNumber id, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType digipostFileType) {
        this(uuid, subject, new RecipientIdentification(id), smsVarsling, authenticationLevel, sensitivityLevel, digipostFileType);
    }

    public Message(String uuid, String subject, OrganisationNumber id, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType digipostFileType) {
        this(uuid, subject, new RecipientIdentification(id), smsVarsling, authenticationLevel, sensitivityLevel, digipostFileType);
    }

    public Message(String uuid, String subject, DigipostAddress digipostAdress, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType digipostFileType) {
        this(uuid, subject, new RecipientIdentification(digipostAdress), smsVarsling, authenticationLevel, sensitivityLevel, digipostFileType);
    }

    public Message(String uuid, String subject, NameAndAddress nameAndAddress, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType digipostFileType) {
        this(uuid, subject, new RecipientIdentification(nameAndAddress), smsVarsling, authenticationLevel, sensitivityLevel, digipostFileType);
    }

    public Message(String uuid, String subject, RecipientIdentification recipient, SmsNotification smsVarsling, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, FileType digipostFileType) {
        this.uuid = uuid.toLowerCase();
        if (!UUID_PATTERN.matcher(this.uuid).matches()) {
            throw new IllegalArgumentException("Not a UUID: " + uuid);
        }
        this.subject = subject;
        this.recipient = recipient;
        this.smsNotification = smsVarsling;
        this.authenticationLevel = authenticationLevel;
        this.sensitivityLevel = sensitivityLevel;
        this.digipostFileType = digipostFileType.toString();
    }

    public Message(String uuid, PrintDetails printDetails) {
        this(uuid, null, new RecipientIdentification(printDetails), null, null, null, FileType.PDF);
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean hasSubject() {
        return !StringUtils.isBlank((String)this.subject);
    }

    public SmsNotification getSmsNotification() {
        return this.smsNotification;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public SensitivityLevel getSensitivityLevel() {
        return this.sensitivityLevel;
    }

    public RecipientIdentification getRecipient() {
        return this.recipient;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isPreEncrypt() {
        return this.preEncrypt != null && this.preEncrypt != false;
    }

    public boolean isSameMessageAs(Message message) {
        return this.uuid.equals(message.getUuid());
    }

    public void setPreEncrypt() {
        this.preEncrypt = true;
    }

    public void setSenderId(long senderId) {
        this.senderId = senderId;
    }

    public void setPreEncrypt(boolean preEncrypt) {
        this.preEncrypt = preEncrypt;
    }

    public boolean isDirectPrint() {
        return this.recipient.isDirectPrint();
    }

    public FileType getDigipostFileType() {
        return new FileType(this.digipostFileType);
    }

    public void setDigipostFileType(FileType fileType) {
        this.digipostFileType = fileType.toString();
    }
}

