/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.security;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;

public class CryptoUtil {
    public static PrivateKey loadKeyFromP12(InputStream certificateStream, String passord) {
        RSAPrivateCrtKey key;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(certificateStream, passord.toCharArray());
            String onlyKeyAlias = keyStore.aliases().nextElement();
            key = (RSAPrivateCrtKey)keyStore.getKey(onlyKeyAlias, passord.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Det skjedde en feil ved lasting av n\u00f8kkelen", e);
        }
        if (key == null) {
            throw new RuntimeException("N\u00f8kkelen som ble lastet, var null");
        }
        return key;
    }

    public static byte[] sign(PrivateKey privateKey, String messageToSign) {
        try {
            Signature instance = Signature.getInstance("SHA256WithRSAEncryption");
            instance.initSign(privateKey);
            instance.update(messageToSign.getBytes());
            return instance.sign();
        }
        catch (Exception e) {
            throw new RuntimeException("Det skjedde en feil ved signeringen", e);
        }
    }
}

