/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStream;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.MessageSender;
import no.digipost.api.client.filters.request.RequestContentSHA256Filter;
import no.digipost.api.client.filters.request.RequestDateFilter;
import no.digipost.api.client.filters.request.RequestSignatureFilter;
import no.digipost.api.client.filters.request.RequestUserAgentFilter;
import no.digipost.api.client.filters.response.ResponseContentSHA256Filter;
import no.digipost.api.client.filters.response.ResponseDateFilter;
import no.digipost.api.client.filters.response.ResponseSignatureFilter;
import no.digipost.api.client.representations.Attachment;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.DeliveryMethod;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.security.FileKeystoreSigner;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.util.JerseyClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigipostClient {
    public static final EventLogger NOOP_EVENT_LOGGER = new EventLogger(){

        @Override
        public void log(String eventText) {
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(DigipostClient.class);
    private final EventLogger eventLogger;
    private final ApiService apiService;

    public DigipostClient(String digipostUrl, long senderAccountId, InputStream certificateP12File, String certificatePassword) {
        this(digipostUrl, senderAccountId, (Signer)new FileKeystoreSigner(certificateP12File, certificatePassword), NOOP_EVENT_LOGGER);
    }

    public DigipostClient(String digipostUrl, long senderAccountId, InputStream certificateP12File, String sertifikatPassord, EventLogger eventLogger) {
        this(digipostUrl, senderAccountId, (Signer)new FileKeystoreSigner(certificateP12File, sertifikatPassord), eventLogger);
    }

    public DigipostClient(String digipostUrl, long senderAccountId, Signer signer) {
        this(digipostUrl, senderAccountId, signer, NOOP_EVENT_LOGGER);
    }

    public DigipostClient(String digipostUrl, long senderAccountId, Signer signer, Client jerseyClient) {
        this(digipostUrl, senderAccountId, signer, NOOP_EVENT_LOGGER, jerseyClient);
    }

    public DigipostClient(String digipostUrl, long senderAccountId, Signer signer, EventLogger eventLogger) {
        this(digipostUrl, senderAccountId, signer, eventLogger, null);
    }

    public DigipostClient(String digipostUrl, long senderAccountId, Signer signer, EventLogger eventLogger, Client jerseyClient) {
        this.eventLogger = eventLogger != null ? eventLogger : NOOP_EVENT_LOGGER;
        Client client = jerseyClient == null ? JerseyClientProvider.newClient() : jerseyClient;
        WebResource webResource = client.resource(digipostUrl);
        this.apiService = new ApiService(webResource, senderAccountId);
        webResource.addFilter((ClientFilter)new RequestContentSHA256Filter(eventLogger));
        webResource.addFilter((ClientFilter)new RequestSignatureFilter(signer, eventLogger));
        webResource.addFilter((ClientFilter)new RequestDateFilter(eventLogger));
        webResource.addFilter((ClientFilter)new RequestUserAgentFilter());
        webResource.addFilter((ClientFilter)new ResponseDateFilter());
        webResource.addFilter((ClientFilter)new ResponseContentSHA256Filter());
        webResource.addFilter((ClientFilter)new ResponseSignatureFilter(this.apiService));
        this.log("Initialiserte Jersey-klient mot " + digipostUrl);
    }

    public MessageDelivery createAndSendMessage(Message message, InputStream letterContent) {
        return this.createAndSendMessage(message, letterContent, letterContent);
    }

    public MessageDelivery createAndSendMessage(Message message, InputStream letterContent, InputStream printContent) {
        return new MessageSender(this.apiService, this.eventLogger).createAndSendMessage(message, letterContent, printContent);
    }

    public MessageDelivery createMessageAndDeliverToPrint(Message printMessage, InputStream printMessageContent) {
        if (!printMessage.isDirectPrint()) {
            throw new IllegalArgumentException("Direct print messages must have PrintDetails and cannot have DigipostAddress, PersonalIdentificationNumber or NameAndAddress");
        }
        return new MessageSender(this.apiService, this.eventLogger).createAndSendMessage(printMessage, null, printMessageContent);
    }

    public MessageDelivery createMessage(Message message, InputStream letterContent) {
        return this.createMessage(message, letterContent, letterContent);
    }

    public MessageDelivery createMessage(Message message, InputStream letterContent, InputStream printContent) {
        return new MessageSender(this.apiService, this.eventLogger).createMessageAndAddContent(message, letterContent, printContent);
    }

    public MessageDelivery createAttachment(MessageDelivery delivery, Attachment attachment, InputStream digipostContent) {
        return this.createAttachment(delivery, attachment, digipostContent, digipostContent);
    }

    public MessageDelivery createAttachment(MessageDelivery delivery, Attachment attachment, InputStream digipostContent, InputStream printContent) {
        return new MessageSender(this.apiService, this.eventLogger).createAttachmentAndAddContent(delivery, attachment, digipostContent, printContent);
    }

    public MessageDelivery sendMessage(MessageDelivery message) {
        return new MessageSender(this.apiService, this.eventLogger).sendMessage(message);
    }

    public MessageDelivery deliverToPrint(MessageDelivery printMessage) {
        if (printMessage.getDeliveryMethod() != DeliveryMethod.PRINT) {
            throw new IllegalArgumentException("Direct print messages must have PrintDetails and cannot have DigipostAddress, PersonalIdentificationNumber or NameAndAddress");
        }
        return new MessageSender(this.apiService, this.eventLogger).sendMessage(printMessage);
    }

    public IdentificationResult identifyRecipient(Identification identification) {
        return this.apiService.identifyRecipient(identification);
    }

    public Recipients search(String searchString) {
        return this.apiService.search(searchString);
    }

    public Autocomplete getAutocompleteSuggestions(String searchString) {
        return this.apiService.searchSuggest(searchString);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    public void addFilter(ClientFilter filter) {
        this.apiService.addFilter(filter);
    }
}

