/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.ErrorType;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.representations.Attachment;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.MessageStatus;

public class MessageSender
extends Communicator {
    public MessageSender(ApiService apiService, EventLogger eventLogger) {
        super(apiService, eventLogger);
    }

    public MessageDelivery createAndSendMessage(Message message, InputStream letterContent) {
        return this.createAndSendMessage(message, letterContent, letterContent);
    }

    public MessageDelivery createAndSendMessage(Message message, InputStream letterContent, InputStream printContent) {
        MessageDelivery delivery;
        InputStream unencryptetContent;
        this.log("\n\n---STARTER INTERAKSJON MED API: OPPRETTE FORSENDELSE---");
        MessageDelivery createdMessage = this.createOrFetchMessage(message);
        if (createdMessage.willBeDeliveredInDigipost()) {
            unencryptetContent = letterContent;
        } else {
            unencryptetContent = printContent;
            message.setDigipostFileType(FileType.PDF);
        }
        if (message.isPreEncrypt()) {
            this.log("\n\n---FORSENDELSE SKAL PREKRYPTERES, STARTER INTERAKSJON MED API: HENT PUBLIC KEY---");
            InputStream encryptetContent = this.fetchKeyAndEncrypt(createdMessage, unencryptetContent);
            delivery = this.uploadContentAndSend(createdMessage, encryptetContent);
        } else {
            delivery = this.uploadContentAndSend(createdMessage, unencryptetContent);
        }
        this.log("\n\n---API-INTERAKSJON ER FULLF\u00d8RT (OG BREVET ER DERMED SENDT)---");
        return delivery;
    }

    public MessageDelivery createMessageAndAddContent(Message message, InputStream letterContent, InputStream printContent) {
        MessageDelivery delivery;
        InputStream unencryptetContent;
        this.log("\n\n---STARTER INTERAKSJON MED API: OPPRETTE FORSENDELSE---");
        MessageDelivery createdMessage = this.createOrFetchMessage(message);
        if (createdMessage.willBeDeliveredInDigipost()) {
            unencryptetContent = letterContent;
        } else {
            unencryptetContent = printContent;
            message.setDigipostFileType(FileType.PDF);
        }
        if (message.isPreEncrypt()) {
            this.log("\n\n---FORSENDELSE SKAL PREKRYPTERES, STARTER INTERAKSJON MED API: HENT PUBLIC KEY---");
            InputStream encryptetContent = this.fetchKeyAndEncrypt(createdMessage, unencryptetContent);
            delivery = this.uploadContent(createdMessage, encryptetContent);
        } else {
            delivery = this.uploadContent(createdMessage, unencryptetContent);
        }
        this.log("\n\n---API-INTERAKSJON ER FULLF\u00d8RT (OG BREVET ER DERMED OPPRETTET)---");
        return delivery;
    }

    public MessageDelivery createAttachmentAndAddContent(MessageDelivery delivery, Attachment attachment, InputStream attachmentContent, InputStream printContent) {
        MessageDelivery messageWithAttachment;
        InputStream unencryptetContent;
        this.log("\n\n---OPPRETTER VEDLEGG---");
        Attachment createdAttachment = this.createAttachment(delivery, attachment);
        if (delivery.willBeDeliveredInDigipost()) {
            unencryptetContent = attachmentContent;
        } else {
            unencryptetContent = printContent;
            attachment.setFileType(FileType.PDF);
        }
        if (delivery.getEncryptionKeyLink() != null) {
            this.log("\n\n---VEDLEGG SKAL PREKRYPTERES, STARTER INTERAKSJON MED API: HENT PUBLIC KEY---");
            InputStream encryptetContent = this.fetchKeyAndEncrypt(delivery, unencryptetContent);
            messageWithAttachment = this.uploadContentToAttachment(createdAttachment, delivery, encryptetContent);
        } else {
            messageWithAttachment = this.uploadContentToAttachment(createdAttachment, delivery, unencryptetContent);
        }
        this.log("\n\n---FERDIG MED \u00c5 LASTE OPP INNHOLD TIL VEDLEGG---");
        return messageWithAttachment;
    }

    public MessageDelivery sendMessage(MessageDelivery message) {
        MessageDelivery deliveredMessage = null;
        if (message.isAlreadyDeliveredToDigipost()) {
            this.log("\n\n---BREVET ER ALLEREDE SENDT");
        } else if (message.getSendLink() == null) {
            this.log("\n\n---BREVET ER IKKE KOMPLETT, KAN IKKE SENDE");
        } else {
            deliveredMessage = this.send(message);
        }
        return deliveredMessage;
    }

    private MessageDelivery uploadContentAndSend(MessageDelivery createdMessage, InputStream unencryptetContent) {
        this.log("\n\n---STARTER INTERAKSJON MED API: LEGGE TIL FIL---");
        return this.addContentAndSendMessage(createdMessage, unencryptetContent);
    }

    private MessageDelivery uploadContent(MessageDelivery createdMessage, InputStream unencryptetContent) {
        this.log("\n\n---STARTER INTERAKSJON MED API: LEGGE TIL FIL---");
        return this.addContent(createdMessage, unencryptetContent);
    }

    private MessageDelivery uploadContentToAttachment(Attachment attachment, MessageDelivery createdMessage, InputStream unencryptetContent) {
        this.log("\n\n---STARTER INTERAKSJON MED API: LEGGE TIL FIL---");
        return this.addContentToAttachment(createdMessage, attachment, unencryptetContent);
    }

    public MessageDelivery createOrFetchMessage(Message message) {
        ClientResponse response = this.apiService.createMessage(message);
        if (this.resourceAlreadyExists(response)) {
            ClientResponse existingMessageResponse = this.apiService.fetchExistingMessage(response.getLocation());
            this.checkResponse(existingMessageResponse);
            MessageDelivery delivery = (MessageDelivery)existingMessageResponse.getEntity(MessageDelivery.class);
            this.checkThatExistingMessageIsIdenticalToNewMessage(delivery, message);
            this.checkThatMessageHasNotAlreadyBeenDelivered(delivery);
            this.log("Identisk forsendelse fantes fra f\u00f8r. Bruker denne istedenfor \u00e5 opprette ny. Status: [" + response.toString() + "]");
            return delivery;
        }
        this.check404Error(response, ErrorType.RECIPIENT_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Forsendelse opprettet. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(MessageDelivery.class);
    }

    public Attachment createAttachment(MessageDelivery delivery, Attachment attachment) {
        ClientResponse response = this.apiService.createAttachment(delivery, attachment);
        if (this.resourceAlreadyExists(response)) {
            String errorMessage = this.fetchErrorMessageString(response);
            this.log("En feil oppsto under opprettelse av vedlegg: " + errorMessage);
            throw new DigipostClientException(ErrorType.PROBLEM_WITH_REQUEST, errorMessage);
        }
        this.check404Error(response, ErrorType.MESSAGE_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Vedlegg opprettet. Status: [" + response.toString() + "]");
        return (Attachment)response.getEntity(Attachment.class);
    }

    public MessageDelivery addContentAndSendMessage(MessageDelivery delivery, InputStream letterContent) {
        this.verifyCorrectStatus(delivery, MessageStatus.NOT_COMPLETE);
        ClientResponse response = this.apiService.addContentAndSend(delivery, letterContent);
        this.check404Error(response, ErrorType.MESSAGE_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Innhold ble lagt til og brevet sendt. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(delivery.getClass());
    }

    public MessageDelivery addContent(MessageDelivery delivery, InputStream letterContent) {
        this.verifyCorrectStatus(delivery, MessageStatus.NOT_COMPLETE);
        ClientResponse response = this.apiService.addContent(delivery, letterContent);
        this.check404Error(response, ErrorType.MESSAGE_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Innhold ble lagt til. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(delivery.getClass());
    }

    public MessageDelivery addContentToAttachment(MessageDelivery delivery, Attachment attachment, InputStream attachmentContent) {
        this.verifyCorrectStatus(delivery, MessageStatus.COMPLETE);
        ClientResponse response = this.apiService.addContentToAttachment(attachment, attachmentContent);
        this.check404Error(response, ErrorType.MESSAGE_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Innhold ble lagt til. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(delivery.getClass());
    }

    private MessageDelivery send(MessageDelivery delivery) {
        this.verifyCorrectStatus(delivery, MessageStatus.COMPLETE);
        ClientResponse response = this.apiService.send(delivery);
        this.check404Error(response, ErrorType.MESSAGE_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Brevet ble sendt. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(delivery.getClass());
    }

    private void checkThatMessageHasNotAlreadyBeenDelivered(MessageDelivery existingMessage) {
        switch (existingMessage.getStatus()) {
            case DELIVERED: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til mottaker den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveredDate());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorType.DIGIPOST_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
            case DELIVERED_TO_PRINT: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til print den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveredDate());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorType.PRINT_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
        }
    }

    protected void verifyCorrectStatus(MessageDelivery createdMessage, MessageStatus expectedStatus) {
        if (createdMessage.getStatus() != expectedStatus) {
            throw new DigipostClientException(ErrorType.INVALID_TRANSACTION, "Kan ikke legge til innhold til en forsendelse som ikke er i tilstanden " + (Object)((Object)expectedStatus) + ".");
        }
    }
}

