/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.request;

import com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.security.ClientRequestToSign;
import no.digipost.api.client.security.RequestMessageSignatureUtil;
import no.digipost.api.client.security.Signer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSignatureFilter
extends ClientFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSignatureFilter.class);
    private final Signer signer;
    private final EventLogger eventLogger;

    public RequestSignatureFilter(Signer signer) {
        this(signer, DigipostClient.NOOP_EVENT_LOGGER);
    }

    public RequestSignatureFilter(Signer signer, EventLogger eventListener) {
        this.signer = signer;
        this.eventLogger = eventListener != null ? eventListener : DigipostClient.NOOP_EVENT_LOGGER;
    }

    public ClientResponse handle(ClientRequest cr) {
        if (cr.getEntity() == null) {
            this.setSignatureHeader(cr);
        } else {
            cr.setAdapter((ClientRequestAdapter)new SikkerhetsAdapter(cr.getAdapter()));
        }
        return this.getNext().handle(cr);
    }

    private void setSignatureHeader(ClientRequest request) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String stringToSign = RequestMessageSignatureUtil.getCanonicalRequestRepresentation(new ClientRequestToSign(request));
        this.log(((Object)((Object)this)).getClass().getSimpleName() + " beregnet streng som skal signeres:\n===START SIGNATURSTRENG===\n" + stringToSign + "===SLUTT SIGNATURSTRENG===");
        byte[] signatureBytes = this.signer.sign(stringToSign);
        String signature = new String(Base64.encodeBase64((byte[])signatureBytes));
        request.getHeaders().add((Object)"X-Digipost-Signature", (Object)signature);
        this.log(((Object)((Object)this)).getClass().getSimpleName() + " satt headeren " + "X-Digipost-Signature" + "=" + signature);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    private final class SecurityAdapterOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream byteArrayOutputStream;
        private final OutputStream jerseyStream;
        private final ClientRequest request;

        public SecurityAdapterOutputStream(ClientRequest request, OutputStream jerseyStream) {
            this.request = request;
            this.jerseyStream = jerseyStream;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.byteArrayOutputStream.write(b);
        }

        @Override
        public void close() throws IOException {
            RequestSignatureFilter.this.setSignatureHeader(this.request);
            this.writeTemporarilyToJerseystream();
            this.jerseyStream.close();
            super.close();
        }

        private void writeTemporarilyToJerseystream() throws IOException {
            IOUtils.write((byte[])this.byteArrayOutputStream.toByteArray(), (OutputStream)this.jerseyStream);
            this.byteArrayOutputStream.close();
        }
    }

    private final class SikkerhetsAdapter
    extends AbstractClientRequestAdapter {
        SikkerhetsAdapter(ClientRequestAdapter cra) {
            super(cra);
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            return new SecurityAdapterOutputStream(request, this.getAdapter().adapt(request, out));
        }
    }
}

