/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.response;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Calendar;
import java.util.Date;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.ErrorType;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.DateUtils;

public class ResponseDateFilter
extends ClientFilter {
    private static final int AKSEPTABEL_TIDSDIFFERANSE_MINUTTER = 5;

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(cr);
        String dateHeader = (String)response.getHeaders().getFirst((Object)"Date");
        if (!StringUtils.isBlank((String)dateHeader)) {
            this.sjekkDato(dateHeader);
            return response;
        }
        throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Mangler dato-header, s\u00e5 server-signatur kunne ikke sjekkes");
    }

    private void sjekkDato(String dateOnRFC1123Format) {
        Date date = DateUtils.parseDate((String)dateOnRFC1123Format);
        if (date == null) {
            throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Dato-header kunne ikke parses, s\u00e5 server-signatur kunne ikke sjekkes");
        }
        this.sjekkAtDatoHeaderIkkeErForGammel(dateOnRFC1123Format, date);
        this.sjekkAtDatoHeaderIkkeErForNy(dateOnRFC1123Format, date);
    }

    private void sjekkAtDatoHeaderIkkeErForGammel(String headerDate, Date parsedDate) {
        int akseptabelTidsdifferanse = 5;
        Calendar tidligsteTillatteTidspunkt = Calendar.getInstance();
        tidligsteTillatteTidspunkt.add(12, -akseptabelTidsdifferanse);
        if (parsedDate.before(tidligsteTillatteTidspunkt.getTime())) {
            throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Dato-header fra server er for gammel: " + headerDate);
        }
    }

    private void sjekkAtDatoHeaderIkkeErForNy(String headerDate, Date parsedDate) {
        int akseptabelTidsdifferanse = 5;
        Calendar senesteTillatteTidspunkt = Calendar.getInstance();
        senesteTillatteTidspunkt.add(12, akseptabelTidsdifferanse);
        if (parsedDate.after(senesteTillatteTidspunkt.getTime())) {
            throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Dato-header fra server er for ny: " + headerDate);
        }
    }
}

