/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.response;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.ErrorType;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.security.ClientResponseToVerify;
import no.digipost.api.client.security.ResponseMessageSignatureUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class ResponseSignatureFilter
extends ClientFilter {
    private final EventLogger eventLogger;
    private final ApiService apiService;

    public ResponseSignatureFilter(ApiService apiService) {
        this(DigipostClient.NOOP_EVENT_LOGGER, apiService);
    }

    public ResponseSignatureFilter(EventLogger eventLogger, ApiService apiService) {
        this.eventLogger = eventLogger;
        this.apiService = apiService;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(cr);
        if ("/".equals(cr.getURI().getPath())) {
            this.eventLogger.log("Verifiserer ikke signatur fordi det er rotressurs vi hentet.");
            return response;
        }
        String serverSignaturBase64 = this.getServerSignaturFromResponse(response);
        byte[] serverSignaturBytes = Base64.decodeBase64((byte[])serverSignaturBase64.getBytes());
        String signatureString = ResponseMessageSignatureUtil.getCanonicalResponseRepresentation(new ClientResponseToVerify(cr, response));
        try {
            Signature instance = Signature.getInstance("SHA256WithRSAEncryption");
            instance.initVerify(this.lastSertifikat());
            instance.update(signatureString.getBytes());
            boolean verified = instance.verify(serverSignaturBytes);
            if (!verified) {
                throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Melding fra server matcher ikke signatur.");
            }
            this.eventLogger.log("Verifiserte signert respons fra Digipost. Signatur fra HTTP-headeren X-Digipost-Signature var OK: " + new String(serverSignaturBase64));
        }
        catch (Exception e) {
            throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Det skjedde en feil under signatursjekk.");
        }
        return response;
    }

    private String getServerSignaturFromResponse(ClientResponse response) {
        String serverSignaturString = (String)response.getHeaders().getFirst((Object)"X-Digipost-Signature");
        if (StringUtils.isBlank((String)serverSignaturString)) {
            throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Mangler signatur-header, s\u00e5 server-signatur kunne ikke sjekkes");
        }
        return serverSignaturString;
    }

    public X509Certificate lastSertifikat() {
        try {
            ByteArrayInputStream certStream = new ByteArrayInputStream(this.apiService.getEntryPoint().getCertificate().getBytes());
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate sertifikat = (X509Certificate)cf.generateCertificate(certStream);
            if (sertifikat == null) {
                throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Kunne ikke laste Digipost's public key, s\u00e5 server-signatur kunne ikke sjekkes");
            }
            return sertifikat;
        }
        catch (GeneralSecurityException e) {
            throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Kunne ikke laste Digipost's public key, s\u00e5 server-signatur kunne ikke sjekkes");
        }
    }
}

