/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FileType {
    private static final Pattern ALLOWED_CHARACTERS = Pattern.compile("^[a-zA-Z0-9\\-_]+$");
    public static final FileType PDF = new FileType("pdf");
    public static final FileType HTM = new FileType("htm");
    public static final FileType HTML = new FileType("html");
    public static final FileType XHTML = new FileType("xhtml");
    public static final FileType XHT = new FileType("xht");
    public static final FileType PNG = new FileType("png");
    public static final FileType JPG = new FileType("jpg");
    public static final FileType JPEG = new FileType("jpeg");
    public static final FileType GIF = new FileType("gif");
    private final String fileType;

    public FileType(String fileType) {
        this.fileType = fileType == null || fileType.length() >= 30 || !ALLOWED_CHARACTERS.matcher(fileType).matches() ? "" : fileType.toLowerCase();
    }

    public String toString() {
        return this.isBlank() ? "" : this.fileType;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fileType).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileType other = (FileType)obj;
        return new EqualsBuilder().append((Object)this.fileType, (Object)other.fileType).isEquals();
    }

    public boolean isBlank() {
        return StringUtils.isBlank((String)this.fileType);
    }

    public static FileType fromFilename(String filename) {
        return new FileType(FilenameUtils.getExtension((String)filename));
    }
}

