/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import no.digipost.api.client.representations.Attachment;
import no.digipost.api.client.representations.ContentHash;
import no.digipost.api.client.representations.DeliveryMethod;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageStatus;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message-delivery", propOrder={"messageId", "deliveryMethod", "status", "deliveredDate", "contentHash", "links", "attachments"})
@XmlRootElement(name="message-delivery")
public class MessageDelivery
extends Representation {
    @XmlElement(name="message-id", required=true)
    protected String messageId;
    @XmlElement(name="delivery-method", required=true)
    protected DeliveryMethod deliveryMethod;
    @XmlElement(required=true)
    protected MessageStatus status;
    @XmlElement(name="delivered-date", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected DateTime deliveredDate;
    @XmlElement(name="content-hash", nillable=false)
    protected ContentHash contentHash;
    @XmlElement(name="attachment")
    protected List<Attachment> attachments;

    public MessageDelivery() {
    }

    public MessageDelivery(String messageId, DeliveryMethod deliveryMethod, MessageStatus status, DateTime deliveredDate) {
        this.messageId = messageId;
        this.deliveryMethod = deliveryMethod;
        this.status = status;
        this.deliveredDate = deliveredDate;
    }

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    protected void setLinks(List<Link> links) {
        this.links = links;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public ContentHash getContentHash() {
        return this.contentHash;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId.equals(message.getUuid());
    }

    public MessageStatus getStatus() {
        return this.status;
    }

    public Link getEncryptionKeyLink() {
        return this.getLinkByRelationName(Relation.GET_ENCRYPTION_KEY);
    }

    public Link getAddContentAndSendLink() {
        return this.getLinkByRelationName(Relation.ADD_CONTENT_AND_SEND);
    }

    public Link getAddContentLink() {
        return this.getLinkByRelationName(Relation.ADD_CONTENT);
    }

    public Link getSendLink() {
        return this.getLinkByRelationName(Relation.SEND);
    }

    public Link getAddAttachmentLink() {
        return this.getLinkByRelationName(Relation.ADD_ATTACHMENT);
    }

    public boolean willBeDeliveredInDigipost() {
        return DeliveryMethod.DIGIPOST.equals((Object)this.deliveryMethod);
    }

    public boolean isAlreadyDeliveredToDigipost() {
        return DeliveryMethod.DIGIPOST.equals((Object)this.deliveryMethod) && this.deliveredDate != null;
    }

    public Link getSelfLink() {
        return this.getLinkByRelationName(Relation.SELF);
    }

    public DeliveryMethod getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public DateTime getDeliveredDate() {
        return this.deliveredDate;
    }
}

