/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.ErrorType;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.Recipients;
import org.apache.commons.io.IOUtils;

public class ApiService {
    private static final String ENTRY_POINT = "/";
    private final WebResource webResource;
    private final long senderAccountId;
    private EntryPoint cachedEntryPoint;
    private long entryPointLastCached;

    public ApiService(WebResource webResource, long senderAccountId) {
        this.webResource = webResource;
        this.senderAccountId = senderAccountId;
    }

    public EntryPoint getEntryPoint() {
        if (this.cachedEntryPoint == null || this.entryPointCacheExpired()) {
            ClientResponse response = this.getEntryPointFromServer();
            if (response.getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                throw new DigipostClientException(ErrorType.GENERAL_ERROR, ((ErrorMessage)response.getEntity(ErrorMessage.class)).getErrorMessage());
            }
            this.cachedEntryPoint = (EntryPoint)response.getEntity(EntryPoint.class);
            this.entryPointLastCached = System.currentTimeMillis();
        }
        return this.cachedEntryPoint;
    }

    private ClientResponse getEntryPointFromServer() {
        return (ClientResponse)((WebResource.Builder)this.webResource.path(ENTRY_POINT).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).get(ClientResponse.class);
    }

    public ClientResponse createMessage(Message message) {
        EntryPoint entryPoint = this.getEntryPoint();
        return (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.webResource.path(entryPoint.getCreateMessageUri().getPath()).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).type("application/vnd.digipost-v5+xml")).post(ClientResponse.class, (Object)message);
    }

    public ClientResponse createPrintMessage(Message message, URI createPrintMessageUri) {
        return (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.webResource.path(createPrintMessageUri.getPath()).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).type("application/vnd.digipost-v5+xml")).post(ClientResponse.class, (Object)message);
    }

    public ClientResponse fetchExistingMessage(URI location) {
        return (ClientResponse)((WebResource.Builder)this.webResource.path(location.getPath()).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).get(ClientResponse.class);
    }

    public ClientResponse getEncryptionKey(URI location) {
        return (ClientResponse)((WebResource.Builder)this.webResource.path(location.getPath()).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).get(ClientResponse.class);
    }

    public ClientResponse addContent(Document document, InputStream letterContent) {
        Link addContentLink = this.fetchAddContentLink(document);
        byte[] content = this.readLetterContent(letterContent);
        return (ClientResponse)((WebResource.Builder)this.webResource.path(addContentLink.getUri().getPath()).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).post(ClientResponse.class, (Object)content);
    }

    public ClientResponse send(MessageDelivery createdMessage) {
        Link sendLink = this.fetchSendLink(createdMessage);
        return (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.webResource.path(sendLink.getUri().getPath()).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).type("application/vnd.digipost-v5+xml")).post(ClientResponse.class);
    }

    private Link fetchAddContentLink(Document document) {
        Link addContentLink = document.getAddContentLink();
        if (addContentLink == null) {
            throw new DigipostClientException(ErrorType.PROBLEM_WITH_REQUEST, "Kan ikke legge til innhold til et dokument som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return addContentLink;
    }

    private Link fetchSendLink(MessageDelivery delivery) {
        Link sendLink = delivery.getSendLink();
        if (sendLink == null) {
            throw new DigipostClientException(ErrorType.PROBLEM_WITH_REQUEST, "Kan ikke sende en forsendelse som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return sendLink;
    }

    byte[] readLetterContent(InputStream letterContent) {
        try {
            return IOUtils.toByteArray((InputStream)letterContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Recipients search(String searchString) {
        return (Recipients)((WebResource.Builder)this.webResource.path(this.getEntryPoint().getSearchUri().getPath() + ENTRY_POINT + searchString).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).get(Recipients.class);
    }

    public Autocomplete searchSuggest(String searchString) {
        return (Autocomplete)((WebResource.Builder)this.webResource.path(this.getEntryPoint().getAutocompleteUri().getPath() + ENTRY_POINT + searchString).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).get(Autocomplete.class);
    }

    public void addFilter(ClientFilter filter) {
        this.webResource.addFilter(filter);
    }

    private boolean entryPointCacheExpired() {
        int fiveMinutes = 300000;
        return System.currentTimeMillis() - this.entryPointLastCached > (long)fiveMinutes;
    }

    public IdentificationResult identifyRecipient(Identification identification) {
        return (IdentificationResult)((WebResource.Builder)((WebResource.Builder)this.webResource.path(this.getEntryPoint().getIdentificationUri().getPath()).accept(new String[]{"application/vnd.digipost-v5+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId)).type("application/vnd.digipost-v5+xml")).post(IdentificationResult.class, (Object)identification);
    }
}

