/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.request;

import com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.crypto.ExtendedDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestContentHashFilter
extends ClientFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContentHashFilter.class);
    private final EventLogger eventLogger;
    private final Class<? extends ExtendedDigest> digestClass;
    private final String header;

    public RequestContentHashFilter(EventLogger eventListener, Class<? extends ExtendedDigest> digestClass, String header) {
        this.eventLogger = eventListener != null ? eventListener : DigipostClient.NOOP_EVENT_LOGGER;
        this.digestClass = digestClass;
        this.header = header;
    }

    public RequestContentHashFilter(Class<? extends ExtendedDigest> digestClass, String header) {
        this(DigipostClient.NOOP_EVENT_LOGGER, digestClass, header);
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        cr.setAdapter((ClientRequestAdapter)new ContentHashAdapter(cr.getAdapter()));
        return this.getNext().handle(cr);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    private final class ContentHashOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream byteArrayOutputStream;
        private final OutputStream jerseyStream;
        private final ClientRequest request;

        public ContentHashOutputStream(ClientRequest request, OutputStream jerseyStream) {
            this.jerseyStream = jerseyStream;
            this.request = request;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.byteArrayOutputStream.write(b);
        }

        @Override
        public void close() throws IOException {
            this.byteArrayOutputStream.close();
            byte[] byteArray = this.byteArrayOutputStream.toByteArray();
            this.settContentHashHeader(byteArray);
            IOUtils.write((byte[])byteArray, (OutputStream)this.jerseyStream);
            this.jerseyStream.close();
        }

        private void settContentHashHeader(byte[] data) {
            try {
                ExtendedDigest instance = (ExtendedDigest)RequestContentHashFilter.this.digestClass.newInstance();
                byte[] result = new byte[instance.getDigestSize()];
                instance.update(data, 0, data.length);
                instance.doFinal(result, 0);
                String hash = new String(Base64.encode((byte[])result));
                this.request.getHeaders().add((Object)RequestContentHashFilter.this.header, (Object)hash);
                RequestContentHashFilter.this.log(RequestContentHashFilter.class.getSimpleName() + " satt headeren " + RequestContentHashFilter.this.header + "=" + hash);
            }
            catch (InstantiationException e) {
                RequestContentHashFilter.this.log("Feil ved generering av " + RequestContentHashFilter.this.header + " : " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                RequestContentHashFilter.this.log("Feil ved generering av " + RequestContentHashFilter.this.header + " : " + e.getMessage());
            }
        }
    }

    private final class ContentHashAdapter
    extends AbstractClientRequestAdapter {
        ContentHashAdapter(ClientRequestAdapter cra) {
            super(cra);
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            return new ContentHashOutputStream(request, this.getAdapter().adapt(request, out));
        }
    }
}

