/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.response;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.ErrorType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.digests.SHA256Digest;

public class ResponseContentSHA256Filter
extends ClientFilter {
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(cr);
        if (response.hasEntity()) {
            this.validerContentHash(response);
        }
        return response;
    }

    private void validerContentHash(ClientResponse response) {
        try {
            String hashHeader = (String)response.getHeaders().getFirst((Object)"X-Content-SHA256");
            if (StringUtils.isBlank((CharSequence)hashHeader)) {
                throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Ikke definert X-Content-SHA256-header, s\u00e5 server-signatur kunne ikke sjekkes");
            }
            byte[] entityBytes = IOUtils.toByteArray((InputStream)response.getEntityInputStream());
            this.validerBytesMotHashHeader(hashHeader, entityBytes);
            response.setEntityInputStream((InputStream)new ByteArrayInputStream(entityBytes));
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "Det skjedde en feil under uthenting av innhold for validering av X-Content-SHA256-header, s\u00e5 server-signatur kunne ikke sjekkes");
        }
    }

    private void validerBytesMotHashHeader(String serverHash, byte[] entityBytes) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(entityBytes, 0, entityBytes.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        String ourHash = new String(Base64.encode((byte[])result));
        if (!serverHash.equals(ourHash)) {
            throw new DigipostClientException(ErrorType.SERVER_SIGNATURE_ERROR, "X-Content-SHA256-header matchet ikke innholdet, s\u00e5 server-signatur er feil.");
        }
    }
}

