/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="authentication-level")
@XmlEnum
public enum AuthenticationLevel {
    PASSWORD(2),
    TWO_FACTOR(3);

    private final int level;

    private AuthenticationLevel(int level) {
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public static AuthenticationLevel fromLevel(int verdi) {
        switch (verdi) {
            case 2: {
                return PASSWORD;
            }
            case 3: {
                return TWO_FACTOR;
            }
        }
        throw new IllegalArgumentException("Unknown authentication level: " + verdi);
    }

    public String value() {
        return this.name();
    }

    public static AuthenticationLevel fromValue(String v) {
        return AuthenticationLevel.valueOf(v);
    }
}

