/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.AuthenticationLevel;
import no.digipost.api.client.representations.ContentHash;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Invoice;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.SensitivityLevel;
import no.digipost.api.client.representations.SmsNotification;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="document", propOrder={"uuid", "subject", "digipostFileType", "openingReceipt", "smsNotification", "authenticationLevel", "sensitivityLevel", "preEncrypt", "contentHash", "links"})
@XmlSeeAlso(value={Invoice.class})
public class Document
extends Representation {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    @XmlElement(name="uuid", required=true)
    protected String uuid;
    @XmlElement(name="subject", required=true)
    protected String subject;
    @XmlElement(name="file-type", required=true)
    protected String digipostFileType;
    @XmlElement(name="opening-receipt")
    protected String openingReceipt;
    @XmlElement(name="sms-notification")
    protected SmsNotification smsNotification;
    @XmlElement(name="authentication-level")
    protected AuthenticationLevel authenticationLevel;
    @XmlElement(name="sensitivity-level")
    protected SensitivityLevel sensitivityLevel;
    @XmlElement(name="pre-encrypt")
    protected Boolean preEncrypt;
    @XmlElement(name="content-hash", nillable=false)
    protected ContentHash contentHash;

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    public Document() {
    }

    public Document(String uuid, String subject, FileType fileType) {
        this(uuid, subject, fileType, null, null, null, null);
    }

    public Document(String uuid, String subject, FileType fileType, String openingReceipt, SmsNotification smsNotification, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel) {
        this.uuid = uuid.toLowerCase();
        if (!UUID_PATTERN.matcher(this.uuid).matches()) {
            throw new IllegalArgumentException("Not a UUID: " + uuid);
        }
        this.subject = subject;
        this.digipostFileType = fileType.toString();
        this.openingReceipt = openingReceipt;
        this.smsNotification = smsNotification;
        this.authenticationLevel = authenticationLevel;
        this.sensitivityLevel = sensitivityLevel;
    }

    public void setDigipostFileType(FileType fileType) {
        this.digipostFileType = fileType.toString();
    }

    public void setPreEncrypt() {
        this.preEncrypt = true;
    }

    public boolean isPreEncrypt() {
        return this.preEncrypt != null && this.preEncrypt != false;
    }

    public Link getAddContentLink() {
        return this.getLinkByRelationName(Relation.ADD_CONTENT);
    }

    public String getUuid() {
        return this.uuid;
    }
}

