/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.DigipostClientException;
import no.digipost.api.client.ErrorType;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.MessageStatus;

public class MessageSender
extends Communicator {
    public MessageSender(ApiService apiService, EventLogger eventLogger) {
        super(apiService, eventLogger);
    }

    public MessageDelivery createAndSendMessage(Message message, InputStream primaryDocumentContent) {
        return this.createAndSendMessage(message, primaryDocumentContent, primaryDocumentContent);
    }

    public MessageDelivery createAndSendMessage(Message message, InputStream primaryDocumentContent, InputStream printContent) {
        MessageDelivery deliveryWithContent;
        InputStream unencryptetContent;
        this.log("\n\n---STARTER INTERAKSJON MED API: OPPRETTE FORSENDELSE---");
        MessageDelivery createdMessage = this.createOrFetchMessage(message);
        Document primaryDocument = createdMessage.getPrimaryDocument();
        if (createdMessage.willBeDeliveredInDigipost()) {
            unencryptetContent = primaryDocumentContent;
        } else {
            unencryptetContent = printContent;
            primaryDocument.setDigipostFileType(FileType.PDF);
        }
        if (primaryDocument.isPreEncrypt()) {
            this.log("\n\n---DOKUMENTET SKAL PREKRYPTERES, STARTER INTERAKSJON MED API: HENT PUBLIC KEY---");
            InputStream encryptetContent = this.fetchKeyAndEncrypt(createdMessage, unencryptetContent);
            deliveryWithContent = this.uploadContent(createdMessage, primaryDocument, encryptetContent);
        } else {
            deliveryWithContent = this.uploadContent(createdMessage, primaryDocument, unencryptetContent);
        }
        MessageDelivery sentMessageDelivery = this.sendMessage(deliveryWithContent);
        this.log("\n\n---API-INTERAKSJON ER FULLF\u00d8RT (OG BREVET ER DERMED SENDT)---");
        return sentMessageDelivery;
    }

    public MessageDelivery createMessageAndAddContent(Message message, InputStream primaryDocumentContent, InputStream printContent) {
        MessageDelivery delivery;
        InputStream unencryptetContent;
        Document primaryDocument = message.getPrimaryDocument();
        this.log("\n\n---STARTER INTERAKSJON MED API: OPPRETTE FORSENDELSE---");
        MessageDelivery createdMessage = this.createOrFetchMessage(message);
        if (createdMessage.willBeDeliveredInDigipost()) {
            unencryptetContent = primaryDocumentContent;
        } else {
            unencryptetContent = printContent;
            primaryDocument.setDigipostFileType(FileType.PDF);
        }
        if (primaryDocument.isPreEncrypt()) {
            this.log("\n\n---DOKUMENTET SKAL PREKRYPTERES, STARTER INTERAKSJON MED API: HENT PUBLIC KEY---");
            InputStream encryptetContent = this.fetchKeyAndEncrypt(createdMessage, unencryptetContent);
            delivery = this.uploadContent(createdMessage, primaryDocument, encryptetContent);
        } else {
            delivery = this.uploadContent(createdMessage, primaryDocument, unencryptetContent);
        }
        return delivery;
    }

    public MessageDelivery sendMessage(MessageDelivery message) {
        MessageDelivery deliveredMessage = null;
        if (message.isAlreadyDeliveredToDigipost()) {
            this.log("\n\n---BREVET ER ALLEREDE SENDT");
        } else if (message.getSendLink() == null) {
            this.log("\n\n---BREVET ER IKKE KOMPLETT, KAN IKKE SENDE");
        } else {
            deliveredMessage = this.send(message);
        }
        return deliveredMessage;
    }

    private MessageDelivery uploadContent(MessageDelivery createdMessage, Document document, InputStream documentContent) {
        this.log("\n\n---STARTER INTERAKSJON MED API: LEGGE TIL FIL---");
        ClientResponse response = this.apiService.addContent(document, documentContent);
        this.check404Error(response, ErrorType.MESSAGE_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Innhold ble lagt til. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(createdMessage.getClass());
    }

    public MessageDelivery createOrFetchMessage(Message message) {
        ClientResponse response = this.apiService.createMessage(message);
        if (this.resourceAlreadyExists(response)) {
            ClientResponse existingMessageResponse = this.apiService.fetchExistingMessage(response.getLocation());
            this.checkResponse(existingMessageResponse);
            MessageDelivery delivery = (MessageDelivery)existingMessageResponse.getEntity(MessageDelivery.class);
            this.checkThatExistingMessageIsIdenticalToNewMessage(delivery, message);
            this.checkThatMessageHasNotAlreadyBeenDelivered(delivery);
            this.log("Identisk forsendelse fantes fra f\u00f8r. Bruker denne istedenfor \u00e5 opprette ny. Status: [" + response.toString() + "]");
            return delivery;
        }
        this.check404Error(response, ErrorType.RECIPIENT_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Forsendelse opprettet. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(MessageDelivery.class);
    }

    public MessageDelivery addContent(MessageDelivery message, Document document, InputStream documentContent, InputStream printDocumentContent) {
        MessageDelivery delivery;
        InputStream unencryptetContent;
        this.verifyCorrectStatus(message, MessageStatus.NOT_COMPLETE);
        if (message.willBeDeliveredInDigipost()) {
            unencryptetContent = documentContent;
        } else {
            unencryptetContent = printDocumentContent;
            document.setDigipostFileType(FileType.PDF);
        }
        if (document.isPreEncrypt()) {
            this.log("\n\n---DOKUMENTET SKAL PREKRYPTERES, STARTER INTERAKSJON MED API: HENT PUBLIC KEY---");
            InputStream encryptetContent = this.fetchKeyAndEncrypt(message, unencryptetContent);
            delivery = this.uploadContent(message, document, encryptetContent);
        } else {
            delivery = this.uploadContent(message, document, unencryptetContent);
        }
        return delivery;
    }

    public MessageDelivery addContent(MessageDelivery delivery, Document document, InputStream documentContent) {
        return this.addContent(delivery, document, documentContent, documentContent);
    }

    private MessageDelivery send(MessageDelivery delivery) {
        ClientResponse response = this.apiService.send(delivery);
        this.check404Error(response, ErrorType.MESSAGE_DOES_NOT_EXIST);
        this.checkResponse(response);
        this.log("Brevet ble sendt. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.getEntity(delivery.getClass());
    }

    private void checkThatMessageHasNotAlreadyBeenDelivered(MessageDelivery existingMessage) {
        switch (existingMessage.getStatus()) {
            case DELIVERED: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til mottaker den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveredDate());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorType.DIGIPOST_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
            case DELIVERED_TO_PRINT: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til print den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveredDate());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorType.PRINT_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
        }
    }

    protected void verifyCorrectStatus(MessageDelivery createdMessage, MessageStatus expectedStatus) {
        if (createdMessage.getStatus() != expectedStatus) {
            throw new DigipostClientException(ErrorType.INVALID_TRANSACTION, "Kan ikke legge til innhold til en forsendelse som ikke er i tilstanden " + (Object)((Object)expectedStatus) + ".");
        }
    }
}

