/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.MessageRecipient;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import org.apache.commons.lang3.ObjectUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message", propOrder={"messageId", "senderId", "recipient", "primaryDocument", "attachments"})
@XmlRootElement(name="message")
public class Message {
    @XmlElement(name="message-id")
    protected String messageId;
    @XmlElement(name="sender-id")
    protected Long senderId;
    @XmlElement(name="recipient")
    protected MessageRecipient recipient;
    @XmlElement(name="primary-document", required=true)
    protected Document primaryDocument;
    @XmlElement(name="attachment")
    protected List<Document> attachments;

    Message() {
    }

    public Message(String messageId, PersonalIdentificationNumber id, Document primaryDocument, Iterable<? extends Document> attachments) {
        this(messageId, new MessageRecipient(id), primaryDocument, attachments);
    }

    public Message(String messageId, OrganisationNumber id, Document primaryDocument, Iterable<? extends Document> attachments) {
        this(messageId, new MessageRecipient(id), primaryDocument, attachments);
    }

    public Message(String messageId, DigipostAddress digipostAdress, Document primaryDocument, Iterable<? extends Document> attachments) {
        this(messageId, new MessageRecipient(digipostAdress), primaryDocument, attachments);
    }

    public Message(String messageId, NameAndAddress nameAndAddress, Document primaryDocument, Iterable<? extends Document> attachments) {
        this(messageId, new MessageRecipient(nameAndAddress), primaryDocument, attachments);
    }

    public Message(String messageId, MessageRecipient recipient, Document primaryDocument, Iterable<? extends Document> attachments) {
        this.messageId = messageId;
        this.recipient = recipient;
        this.primaryDocument = primaryDocument;
        this.attachments = new ArrayList<Document>();
        for (Document attachment : (Iterable)ObjectUtils.defaultIfNull(attachments, Collections.emptyList())) {
            this.attachments.add(attachment);
        }
    }

    public MessageRecipient getRecipient() {
        return this.recipient;
    }

    public void setSenderId(long senderId) {
        this.senderId = senderId;
    }

    public boolean isDirectPrint() {
        return this.recipient.isDirectPrint();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Long getSenderId() {
        return this.senderId;
    }

    public Document getPrimaryDocument() {
        return this.primaryDocument;
    }

    public List<Document> getAttachments() {
        return this.attachments;
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId != null && this.messageId.equals(message.messageId);
    }
}

