/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import no.digipost.api.client.representations.DeliveryMethod;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageStatus;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message-delivery", propOrder={"messageId", "deliveryMethod", "status", "deliveredDate", "primaryDocument", "attachments", "links"})
@XmlRootElement(name="message-delivery")
public class MessageDelivery
extends Representation {
    @XmlElement(name="message-id")
    protected String messageId;
    @XmlElement(name="delivery-method", required=true)
    protected DeliveryMethod deliveryMethod;
    @XmlElement(required=true)
    protected MessageStatus status;
    @XmlElement(name="delivered-date", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected DateTime deliveredDate;
    @XmlElement(name="primary-document", required=true)
    protected Document primaryDocument;
    @XmlElement(name="attachment")
    protected List<Document> attachments;

    public MessageDelivery() {
    }

    public MessageDelivery(String messageId, DeliveryMethod deliveryMethod, MessageStatus status, DateTime deliveredDate) {
        this.messageId = messageId;
        this.deliveryMethod = deliveryMethod;
        this.status = status;
        this.deliveredDate = deliveredDate;
    }

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    protected void setLinks(List<Link> links) {
        this.links = links;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public List<Document> getAttachments() {
        return this.attachments != null ? Collections.unmodifiableList(this.attachments) : Collections.emptyList();
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId.equals(message.getMessageId());
    }

    public MessageStatus getStatus() {
        return this.status;
    }

    public Link getEncryptionKeyLink() {
        return this.getLinkByRelationName(Relation.GET_ENCRYPTION_KEY);
    }

    public Link getSendLink() {
        return this.getLinkByRelationName(Relation.SEND);
    }

    public boolean willBeDeliveredInDigipost() {
        return DeliveryMethod.DIGIPOST.equals((Object)this.deliveryMethod);
    }

    public boolean isAlreadyDeliveredToDigipost() {
        return DeliveryMethod.DIGIPOST.equals((Object)this.deliveryMethod) && this.deliveredDate != null;
    }

    public Link getSelfLink() {
        return this.getLinkByRelationName(Relation.SELF);
    }

    public DeliveryMethod getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public DateTime getDeliveredDate() {
        return this.deliveredDate;
    }

    public Document getPrimaryDocument() {
        return this.primaryDocument;
    }

    public List<Document> getAllDocuments() {
        LinkedList<Document> all = new LinkedList<Document>(this.getAttachments());
        if (this.primaryDocument != null) {
            all.addFirst(this.primaryDocument);
        }
        return Collections.unmodifiableList(all);
    }

    public Document getDocumentByUuid(String uuid) {
        for (Document document : this.getAllDocuments()) {
            if (!uuid.equals(document.getUuid())) continue;
            return document;
        }
        throw new IllegalArgumentException("Document with UUID '" + uuid + "' was not found in this " + this.getClass().getSimpleName() + ".");
    }
}

