@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup
set REPO=


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\org\slf4j\slf4j-api\1.7.6\slf4j-api-1.7.6.jar;"%REPO%"\ch\qos\logback\logback-classic\1.1.1\logback-classic-1.1.1.jar;"%REPO%"\ch\qos\logback\logback-core\1.1.1\logback-core-1.1.1.jar;"%REPO%"\org\apache\httpcomponents\httpclient\4.3.3\httpclient-4.3.3.jar;"%REPO%"\org\apache\httpcomponents\httpcore\4.3.2\httpcore-4.3.2.jar;"%REPO%"\commons-logging\commons-logging\1.1.3\commons-logging-1.1.3.jar;"%REPO%"\commons-codec\commons-codec\1.6\commons-codec-1.6.jar;"%REPO%"\com\sun\jersey\jersey-core\1.18.1\jersey-core-1.18.1.jar;"%REPO%"\com\sun\jersey\jersey-client\1.18.1\jersey-client-1.18.1.jar;"%REPO%"\commons-io\commons-io\2.4\commons-io-2.4.jar;"%REPO%"\org\apache\commons\commons-lang3\3.2.1\commons-lang3-3.2.1.jar;"%REPO%"\javax\xml\bind\jaxb-api\2.2.7\jaxb-api-2.2.7.jar;"%REPO%"\com\sun\xml\bind\jaxb-impl\2.2.7\jaxb-impl-2.2.7.jar;"%REPO%"\com\sun\xml\bind\jaxb-core\2.2.7\jaxb-core-2.2.7.jar;"%REPO%"\com\sun\istack\istack-commons-runtime\2.16\istack-commons-runtime-2.16.jar;"%REPO%"\com\sun\xml\fastinfoset\FastInfoset\1.2.12\FastInfoset-1.2.12.jar;"%REPO%"\javax\xml\bind\jsr173_api\1.0\jsr173_api-1.0.jar;"%REPO%"\org\bouncycastle\bcprov-jdk15on\1.50\bcprov-jdk15on-1.50.jar;"%REPO%"\org\bouncycastle\bcpkix-jdk15on\1.50\bcpkix-jdk15on-1.50.jar;"%REPO%"\joda-time\joda-time\2.3\joda-time-2.3.jar;"%REPO%"\no\digipost\digipost-api-client-java\5.0\digipost-api-client-java-5.0.jar

set ENDORSED_DIR=
if NOT "%ENDORSED_DIR%" == "" set CLASSPATH="%BASEDIR%"\%ENDORSED_DIR%\*;%CLASSPATH%

if NOT "%CLASSPATH_PREFIX%" == "" set CLASSPATH=%CLASSPATH_PREFIX%;%CLASSPATH%

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS%  -classpath %CLASSPATH% -Dapp.name="digipost-api-client" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" no.digipost.api.client.swing.DigipostSwingClient %CMD_LINE_ARGS%
if %ERRORLEVEL% NEQ 0 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
