/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.Recipients;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.joda.time.DateTime;

public class ApiServiceImpl
implements ApiService {
    private static final String ENTRY_POINT = "/";
    private final WebTarget webResource;
    private final long senderAccountId;
    private EntryPoint cachedEntryPoint;
    private long entryPointLastCached;

    public ApiServiceImpl(WebTarget webResource, long senderAccountId) {
        this.webResource = webResource;
        this.senderAccountId = senderAccountId;
    }

    @Override
    public EntryPoint getEntryPoint() {
        if (this.cachedEntryPoint == null || this.entryPointCacheExpired()) {
            Response response = this.getEntryPointFromServer();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                ErrorMessage error = (ErrorMessage)response.readEntity(ErrorMessage.class);
                throw new DigipostClientException(error);
            }
            this.cachedEntryPoint = (EntryPoint)response.readEntity(EntryPoint.class);
            this.entryPointLastCached = System.currentTimeMillis();
        }
        return this.cachedEntryPoint;
    }

    private Response getEntryPointFromServer() {
        return this.webResource.path(ENTRY_POINT).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).get();
    }

    @Override
    public Response multipartMessage(MultiPart multiPart) {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.webResource.path(entryPoint.getCreateMessageUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).post(Entity.entity((Object)multiPart, (String)"multipart/mixed"));
    }

    @Override
    public Response identifyAndGetEncryptionKey(Identification identification) {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.webResource.path(entryPoint.getIdentificationWithEncryptionKeyUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).post(Entity.entity((Object)identification, (String)"application/vnd.digipost-v6+xml"));
    }

    @Override
    public Response createMessage(Message message) {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.webResource.path(entryPoint.getCreateMessageUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).post(Entity.entity((Object)message, (String)"application/vnd.digipost-v6+xml"));
    }

    @Override
    public Response fetchExistingMessage(URI location) {
        return this.webResource.path(location.getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).get();
    }

    @Override
    public Response getEncryptionKey(URI location) {
        return this.webResource.path(location.getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).get();
    }

    @Override
    public Response getEncryptionKeyForPrint() {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.webResource.path(entryPoint.getPrintEncryptionKey().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).get();
    }

    @Override
    public Response addContent(Document document, InputStream letterContent) {
        Link addContentLink = this.fetchAddContentLink(document);
        byte[] content = this.readLetterContent(letterContent);
        return this.webResource.path(addContentLink.getUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).post(Entity.entity((Object)content, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
    }

    @Override
    public Response send(MessageDelivery createdMessage) {
        Link sendLink = this.fetchSendLink(createdMessage);
        return this.webResource.path(sendLink.getUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).post(null);
    }

    private Link fetchAddContentLink(Document document) {
        Link addContentLink = document.getAddContentLink();
        if (addContentLink == null) {
            throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "Kan ikke legge til innhold til et dokument som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return addContentLink;
    }

    private Link fetchSendLink(MessageDelivery delivery) {
        Link sendLink = delivery.getSendLink();
        if (sendLink == null) {
            throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "Kan ikke sende en forsendelse som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return sendLink;
    }

    byte[] readLetterContent(InputStream letterContent) {
        try {
            return IOUtils.toByteArray((InputStream)letterContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response getDocumentEvents(String organisation, String partId, DateTime from, DateTime to, int offset, int maxResults) {
        WebTarget target = this.webResource.path(this.getEntryPoint().getDocumentEventsUri().getPath()).queryParam("from", new Object[]{from.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")}).queryParam("to", new Object[]{to.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")}).queryParam("offset", new Object[]{String.valueOf(offset)}).queryParam("maxResults", new Object[]{String.valueOf(maxResults)});
        if (organisation != null) {
            target = target.queryParam("org", new Object[]{organisation});
        }
        if (partId != null) {
            target = target.queryParam("part", new Object[]{partId});
        }
        return target.request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).get();
    }

    @Override
    public Response getContent(String path) {
        return this.webResource.path(path).request().header("X-Digipost-UserId", (Object)this.senderAccountId).get();
    }

    @Override
    public Recipients search(String searchString) {
        return (Recipients)this.webResource.path(this.getEntryPoint().getSearchUri().getPath() + ENTRY_POINT + searchString).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).get(Recipients.class);
    }

    @Override
    public Autocomplete searchSuggest(String searchString) {
        return (Autocomplete)this.webResource.path(this.getEntryPoint().getAutocompleteUri().getPath() + ENTRY_POINT + searchString).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).get(Autocomplete.class);
    }

    @Override
    public void addFilter(ClientRequestFilter filter) {
        this.webResource.register((Object)filter);
    }

    private boolean entryPointCacheExpired() {
        int fiveMinutes = 300000;
        return System.currentTimeMillis() - this.entryPointLastCached > (long)fiveMinutes;
    }

    @Override
    public IdentificationResult identifyRecipient(Identification identification) {
        return (IdentificationResult)this.webResource.path(this.getEntryPoint().getIdentificationUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.senderAccountId).post(Entity.entity((Object)identification, (String)"application/vnd.digipost-v6+xml"), IdentificationResult.class);
    }
}

