/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.DigipostClientMock;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.DeliveryMethod;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.EncryptionKey;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.ErrorType;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.IdentificationResultWithEncryptionKey;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.MessageStatus;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.util.MockfriendlyResponse;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.bouncycastle.openssl.PEMWriter;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.joda.time.DateTime;
import org.xml.sax.helpers.DefaultHandler;

public class ApiServiceMock
implements ApiService {
    private final EncryptionKey fakeEncryptionKey;
    final Map<Method, RequestsAndResponses> requestsAndResponsesMap = new HashMap<Method, RequestsAndResponses>();
    private final DigipostClientMock.ValidatingMarshaller marshaller;

    public ApiServiceMock(DigipostClientMock.ValidatingMarshaller validatingMarshaller) {
        this.marshaller = validatingMarshaller;
        this.fakeEncryptionKey = ApiServiceMock.createFakeEncryptionKey();
        this.init();
    }

    static EncryptionKey createFakeEncryptionKey() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osWriter = new OutputStreamWriter(baos);
             PEMWriter writer = new PEMWriter((Writer)osWriter);){
            KeyPairGenerator factory = KeyPairGenerator.getInstance("RSA");
            factory.initialize(2048);
            KeyPair keyPair = factory.generateKeyPair();
            writer.writeObject((Object)keyPair.getPublic());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed creation of fake encryption key.", e);
        }
        EncryptionKey fakeKey = new EncryptionKey();
        fakeKey.setKeyId("fake-hash");
        fakeKey.setValue(new String(baos.toByteArray()));
        return fakeKey;
    }

    private void init() {
        this.requestsAndResponsesMap.clear();
        this.requestsAndResponsesMap.put(Method.GET_CONTENT, new RequestsAndResponses());
        this.requestsAndResponsesMap.put(Method.GET_DOCUMENTS_EVENTS, new RequestsAndResponses());
        this.requestsAndResponsesMap.put(Method.MULTIPART_MESSAGE, new RequestsAndResponses(new MultipartRequestMatcher()));
    }

    public void reset() {
        this.init();
    }

    @Override
    public EntryPoint getEntryPoint() {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public Response multipartMessage(MultiPart multiPart) {
        Message message = null;
        ArrayList<ContentPart> contentParts = new ArrayList<ContentPart>();
        for (BodyPart bodyPart : multiPart.getBodyParts()) {
            if (bodyPart.getMediaType().toString().equals("application/vnd.digipost-v6+xml")) {
                message = (Message)bodyPart.getEntity();
                continue;
            }
            contentParts.add(new ContentPart(bodyPart.getMediaType()));
        }
        if (message == null) {
            throw new IllegalArgumentException("MultiPart does not contain Message");
        }
        if (this.marshaller != null) {
            this.marshaller.marshal(message, new DefaultHandler());
        }
        String subject = message.primaryDocument.subject;
        RequestsAndResponses requestsAndResponses = this.requestsAndResponsesMap.get((Object)Method.MULTIPART_MESSAGE);
        Response response = requestsAndResponses.getResponse(subject);
        requestsAndResponses.addRequest(new DigipostRequest(message, contentParts));
        return response;
    }

    @Override
    public Response identifyAndGetEncryptionKey(Identification identification) {
        IdentificationResultWithEncryptionKey mockEntity = new IdentificationResultWithEncryptionKey(IdentificationResult.digipost("fake.address#1234"), this.fakeEncryptionKey);
        return MockfriendlyResponse.MockedResponseBuilder.create().status(Response.Status.OK.getStatusCode()).entity(mockEntity).build();
    }

    @Override
    public Response getEncryptionKeyForPrint() {
        return MockfriendlyResponse.MockedResponseBuilder.create().status(Response.Status.OK.getStatusCode()).entity(this.fakeEncryptionKey).build();
    }

    @Override
    public Response createMessage(Message message) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public Response fetchExistingMessage(URI location) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public Response getEncryptionKey(URI location) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public Response addContent(Document document, InputStream letterContent) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public Response send(MessageDelivery createdMessage) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public Recipients search(String searchString) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public Autocomplete searchSuggest(String searchString) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public void addFilter(ClientRequestFilter filter) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public IdentificationResult identifyRecipient(Identification identification) {
        throw new NotImplementedException("This is a mock");
    }

    @Override
    public Response getDocumentEvents(String organisation, String partId, DateTime from, DateTime to, int offset, int maxResults) {
        RequestsAndResponses requestsAndResponses = this.requestsAndResponsesMap.get((Object)Method.GET_DOCUMENTS_EVENTS);
        Response response = requestsAndResponses.getResponse();
        if (response != null) {
            return response;
        }
        return MockfriendlyResponse.MockedResponseBuilder.create().status(Response.Status.OK.getStatusCode()).entity(new DocumentEvents()).build();
    }

    @Override
    public Response getContent(String path) {
        RequestsAndResponses requestsAndResponses = this.requestsAndResponsesMap.get((Object)Method.GET_CONTENT);
        Response response = requestsAndResponses.getResponse();
        if (response != null) {
            return response;
        }
        return MockfriendlyResponse.MockedResponseBuilder.create().status(Response.Status.NOT_FOUND.getStatusCode()).build();
    }

    public static class ContentPart {
        public final MediaType mediaType;

        public ContentPart(MediaType mediaType) {
            this.mediaType = mediaType;
        }
    }

    public static class DigipostRequest
    extends MockRequest {
        public final Message message;
        public final List<ContentPart> contentParts;

        public DigipostRequest(Message message, List<ContentPart> contentParts) {
            super(message.messageId);
            this.message = message;
            this.contentParts = contentParts;
        }
    }

    public static class MultipartRequestMatcher
    extends RequestMatcher {
        public static Response DEFAULT_RESPONSE = MockfriendlyResponse.MockedResponseBuilder.create().status(Response.Status.OK.getStatusCode()).entity(new MessageDelivery(UUID.randomUUID().toString(), DeliveryMethod.DIGIPOST, MessageStatus.COMPLETE, DateTime.now())).build();
        public static ProcessingException CONNECTION_REFUSED = new ProcessingException((Throwable)new ConnectException("Connection refused"));
        public static final Map<String, Response> responses = new HashMap<String, Response>();
        public static final Map<String, RuntimeException> errors = new HashMap<String, RuntimeException>();

        @Override
        public Response findResponse(String requestString) {
            if (responses.containsKey(requestString)) {
                return responses.get(requestString);
            }
            if (errors.containsKey(requestString)) {
                throw errors.get(requestString);
            }
            if (requestString.matches("^[0-9]{3}:(.)+")) {
                String[] split = requestString.split(":");
                if (ErrorCode.isKnown(split[1])) {
                    ErrorCode errorCode = ErrorCode.resolve(split[1]);
                    ErrorType translated = (ErrorType)EnumUtils.getEnum(ErrorType.class, (String)errorCode.getOverriddenErrorType().name());
                    return MockfriendlyResponse.MockedResponseBuilder.create().status(Integer.parseInt(split[0])).entity(new ErrorMessage(translated != null ? translated : ErrorType.SERVER, errorCode.name(), "Generic error-message from digipost-api-client-mock", new Link[0])).build();
                }
                throw new IllegalArgumentException("ErrorCode " + split[1] + " is unknown");
            }
            return DEFAULT_RESPONSE;
        }

        static {
            responses.put("200:OK", DEFAULT_RESPONSE);
            errors.put("CONNECTION_REFUSED", (RuntimeException)CONNECTION_REFUSED);
        }
    }

    public static class MockRequest {
        private final String key;

        public MockRequest(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class RequestsAndResponses {
        private final Queue<Response> responseQueue = new ConcurrentLinkedQueue<Response>();
        private final RequestMatcher requestMatcher;
        private final Map<String, MockRequest> requestMap;

        RequestsAndResponses() {
            this(new RequestMatcher());
        }

        RequestsAndResponses(RequestMatcher requestMatcher) {
            this.requestMatcher = requestMatcher;
            this.requestMap = Collections.synchronizedMap(new LinkedHashMap<String, MockRequest>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, MockRequest> eldest) {
                    return this.size() > 100;
                }
            });
        }

        public void addExpectedResponse(Response response) {
            this.responseQueue.add(response);
        }

        public Response getResponse() {
            return this.getResponse("default");
        }

        public Response getResponse(String requestString) {
            Response response = this.responseQueue.poll();
            if (response != null) {
                return response;
            }
            return this.requestMatcher.findResponse(requestString);
        }

        public void addRequest(MockRequest request) {
            this.requestMap.put(request.getKey(), request);
        }

        public MockRequest getRequest(String requestKey) {
            return this.requestMap.get(requestKey);
        }

        public Map<String, MockRequest> getRequests() {
            return this.requestMap;
        }
    }

    public static class RequestMatcher {
        public Response findResponse(String requestString) {
            return null;
        }
    }

    public static enum Method {
        GET_CONTENT,
        MULTIPART_MESSAGE,
        GET_DOCUMENTS_EVENTS;

    }
}

