/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.ErrorType;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Communicator {
    private static final Logger LOG = LoggerFactory.getLogger(Communicator.class);
    protected final EventLogger eventLogger;
    protected final ApiService apiService;

    public Communicator(ApiService apiService, EventLogger eventLogger) {
        this.apiService = apiService;
        this.eventLogger = eventLogger;
    }

    protected void checkResponse(Response response) {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (!this.responseOk(status)) {
            ErrorMessage error = this.fetchErrorMessageString(response);
            this.log(error.toString());
            switch (status) {
                case INTERNAL_SERVER_ERROR: {
                    throw new DigipostClientException(ErrorCode.SERVER_ERROR, error.getErrorMessage());
                }
                case SERVICE_UNAVAILABLE: {
                    throw new DigipostClientException(ErrorCode.API_UNAVAILABLE, error.getErrorMessage());
                }
            }
            throw new DigipostClientException(error);
        }
    }

    protected ErrorMessage fetchErrorMessageString(Response response) {
        try {
            return (ErrorMessage)response.readEntity(ErrorMessage.class);
        }
        catch (IllegalStateException | ProcessingException | WebApplicationException e) {
            return new ErrorMessage(ErrorType.SERVER, ErrorCode.SERVER_ERROR.name(), "Det skjedde en feil p\u00e5 serveren, men klienten kunne ikke lese responsen.", new Link[0]);
        }
    }

    private boolean responseOk(Response.Status status) {
        if (status == null) {
            return false;
        }
        switch (status) {
            case CREATED: 
            case OK: {
                return true;
            }
        }
        return false;
    }

    protected void log(String message) {
        LOG.debug(message);
        this.eventLogger.log(message);
    }

    protected void logThrowable(Throwable t) {
        LOG.debug("Feil.", t);
        StringWriter stacktrace = new StringWriter();
        t.printStackTrace(new PrintWriter(stacktrace));
        this.eventLogger.log(stacktrace.toString());
    }

    protected boolean resourceAlreadyExists(Response response) {
        return Response.Status.CONFLICT.equals((Object)Response.Status.fromStatusCode((int)response.getStatus()));
    }

    protected void checkThatExistingMessageIsIdenticalToNewMessage(MessageDelivery exisitingMessage, Message message) {
        if (!exisitingMessage.isSameMessageAs(message)) {
            String errorMessage = "Forsendelse med id [" + message.messageId + "] finnes fra f\u00f8r med annen spesifikasjon.";
            this.log(errorMessage);
            throw new DigipostClientException(ErrorCode.DUPLICATE_MESSAGE, errorMessage);
        }
    }
}

