/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.InputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.ApiServiceImpl;
import no.digipost.api.client.DocumentCommunicator;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.MessageSender;
import no.digipost.api.client.delivery.ApiFlavor;
import no.digipost.api.client.delivery.MessageDeliverer;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.filters.request.RequestContentSHA256Filter;
import no.digipost.api.client.filters.request.RequestDateFilter;
import no.digipost.api.client.filters.request.RequestSignatureFilter;
import no.digipost.api.client.filters.request.RequestUserAgentFilter;
import no.digipost.api.client.filters.response.ResponseContentSHA256Filter;
import no.digipost.api.client.filters.response.ResponseDateFilter;
import no.digipost.api.client.filters.response.ResponseSignatureFilter;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.security.FileKeystoreSigner;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.util.JerseyClientProvider;
import no.digipost.print.validate.PdfValidationSettings;
import no.digipost.print.validate.PdfValidator;
import org.apache.commons.lang3.ObjectUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigipostClient {
    public static final EventLogger NOOP_EVENT_LOGGER = new EventLogger(){

        @Override
        public void log(String eventText) {
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(DigipostClient.class);
    private final EventLogger eventLogger;
    private final ApiService apiService;
    private final MessageSender messageSender;
    private final MessageDeliverer deliverer;
    private final DocumentCommunicator documentCommunicator;
    private final ResponseSignatureFilter responseSignatureFilter;
    private final ResponseContentSHA256Filter responseHashFilter = new ResponseContentSHA256Filter();
    private final ResponseDateFilter responseDateFilter = new ResponseDateFilter();

    public DigipostClient(ApiFlavor deliveryType, String digipostUrl, long senderAccountId, InputStream certificateP12File, String certificatePassword) {
        this(deliveryType, digipostUrl, senderAccountId, new FileKeystoreSigner(certificateP12File, certificatePassword), NOOP_EVENT_LOGGER, null);
    }

    public DigipostClient(ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer) {
        this(deliveryType, digipostUrl, senderAccountId, signer, NOOP_EVENT_LOGGER, null);
    }

    public DigipostClient(ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer, ApiService apiService) {
        this(deliveryType, digipostUrl, senderAccountId, signer, NOOP_EVENT_LOGGER, apiService);
    }

    public DigipostClient(ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer, Client jerseyClient) {
        this(deliveryType, digipostUrl, senderAccountId, signer, NOOP_EVENT_LOGGER, jerseyClient, null);
    }

    public DigipostClient(ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer, EventLogger eventLogger, ApiService apiService) {
        this(deliveryType, digipostUrl, senderAccountId, signer, eventLogger, null, apiService);
    }

    public DigipostClient(ApiFlavor deliveryType, String digipostUrl, long senderAccountId, InputStream certificateP12File, String certificatePassword, EventLogger eventLogger, Client jerseyClient) {
        this(deliveryType, digipostUrl, senderAccountId, new FileKeystoreSigner(certificateP12File, certificatePassword), eventLogger, jerseyClient, null);
    }

    public DigipostClient(ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer, EventLogger eventLogger, Client jerseyClient, ApiService overriddenApiService) {
        WebTarget webTarget = ((Client)(jerseyClient == null ? JerseyClientProvider.newClient() : jerseyClient).register((Object)new GZipEncoder())).target(digipostUrl);
        this.apiService = overriddenApiService == null ? new ApiServiceImpl(webTarget, senderAccountId) : overriddenApiService;
        this.eventLogger = (EventLogger)ObjectUtils.defaultIfNull((Object)eventLogger, (Object)NOOP_EVENT_LOGGER);
        this.messageSender = new MessageSender(this.apiService, eventLogger, new PdfValidator());
        this.deliverer = new MessageDeliverer(deliveryType, this.messageSender);
        this.documentCommunicator = new DocumentCommunicator(this.apiService, eventLogger);
        this.responseSignatureFilter = new ResponseSignatureFilter(this.apiService);
        webTarget.register((Object)new LoggingFilter());
        webTarget.register((Object)new RequestContentSHA256Filter(eventLogger));
        webTarget.register((Object)new RequestDateFilter(eventLogger));
        webTarget.register((Object)new RequestUserAgentFilter());
        webTarget.register((Object)new RequestSignatureFilter(signer, eventLogger));
        webTarget.register((Object)this.responseDateFilter);
        webTarget.register((Object)this.responseHashFilter);
        webTarget.register((Object)this.responseSignatureFilter);
        this.log("Initialiserte Jersey-klient mot " + digipostUrl);
    }

    public DigipostClient setThrowOnResponseValidationError(boolean throwOnError) {
        this.responseDateFilter.setThrowOnError(throwOnError);
        this.responseHashFilter.setThrowOnError(throwOnError);
        this.responseSignatureFilter.setThrowOnError(throwOnError);
        return this;
    }

    public DigipostClient setPdfValidationSettings(PdfValidationSettings settings) {
        this.messageSender.setPdfValidationSettings(settings);
        return this;
    }

    public OngoingDelivery.WithPrintFallback createMessage(Message message) {
        return this.deliverer.createMessage(message);
    }

    public OngoingDelivery.ForPrintOnly createPrintOnlyMessage(Message printMessage) {
        return this.deliverer.createPrintOnlyMessage(printMessage);
    }

    public IdentificationResult identifyRecipient(Identification identification) {
        return this.apiService.identifyRecipient(identification);
    }

    public Recipients search(String searchString) {
        return this.apiService.search(searchString);
    }

    public Autocomplete getAutocompleteSuggestions(String searchString) {
        return this.apiService.searchSuggest(searchString);
    }

    public DocumentEvents getDocumentEvents(DateTime from, DateTime to, int offset, int maxResults) {
        return this.getDocumentEvents(null, null, from, to, offset, maxResults);
    }

    public DocumentEvents getDocumentEvents(String organisation, String partId, DateTime from, DateTime to, int offset, int maxResults) {
        return this.documentCommunicator.getDocumentEvents(organisation, partId, from, to, offset, maxResults);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    public static JerseyClient createJerseyClientWithoutSSLValidation() {
        TrustManager[] noopTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        HostnameVerifier noopHostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, noopTrustManager, new SecureRandom());
            ClientConfig c = new ClientConfig();
            c.register(LoggingFilter.class);
            c.register(MultiPartFeature.class);
            return new JerseyClientBuilder().sslContext(sc).withConfig((Configuration)c).hostnameVerifier(noopHostnameVerifier).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getContent(String path) {
        return this.documentCommunicator.getContent(path);
    }
}

