/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.request;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.security.ClientRequestToSign;
import no.digipost.api.client.security.RequestMessageSignatureUtil;
import no.digipost.api.client.security.Signer;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5000)
public class RequestSignatureFilter
implements ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSignatureFilter.class);
    private final Signer signer;
    private final EventLogger eventLogger;

    public RequestSignatureFilter(Signer signer) {
        this(signer, DigipostClient.NOOP_EVENT_LOGGER);
    }

    public RequestSignatureFilter(Signer signer, EventLogger eventListener) {
        this.signer = signer;
        this.eventLogger = eventListener != null ? eventListener : DigipostClient.NOOP_EVENT_LOGGER;
    }

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        if (clientRequestContext.getEntity() == null) {
            this.setSignatureHeader(clientRequestContext);
        } else {
            clientRequestContext.setEntityStream((OutputStream)new SecurityAdapterOutputStream(clientRequestContext, clientRequestContext.getEntityStream()));
        }
    }

    private void setSignatureHeader(ClientRequestContext request) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String stringToSign = RequestMessageSignatureUtil.getCanonicalRequestRepresentation(new ClientRequestToSign(request));
        this.log(this.getClass().getSimpleName() + " beregnet streng som skal signeres:\n===START SIGNATURSTRENG===\n" + stringToSign + "===SLUTT SIGNATURSTRENG===");
        byte[] signatureBytes = this.signer.sign(stringToSign);
        String signature = new String(Base64.encode((byte[])signatureBytes));
        request.getHeaders().add((Object)"X-Digipost-Signature", (Object)signature);
        this.log(this.getClass().getSimpleName() + " satt headeren " + "X-Digipost-Signature" + "=" + signature);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    private final class SecurityAdapterOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream byteArrayOutputStream;
        private final OutputStream jerseyStream;
        private final ClientRequestContext request;

        public SecurityAdapterOutputStream(ClientRequestContext request, OutputStream jerseyStream) {
            this.request = request;
            this.jerseyStream = jerseyStream;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.byteArrayOutputStream.write(b);
        }

        @Override
        public void close() throws IOException {
            RequestSignatureFilter.this.setSignatureHeader(this.request);
            this.writeTemporarilyToJerseystream();
            this.jerseyStream.close();
            super.close();
        }

        private void writeTemporarilyToJerseystream() throws IOException {
            IOUtils.write((byte[])this.byteArrayOutputStream.toByteArray(), (OutputStream)this.jerseyStream);
            this.byteArrayOutputStream.close();
        }
    }
}

