/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.util.LoggingUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseContentSHA256Filter
implements ClientResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseContentSHA256Filter.class);
    private boolean shouldThrow = true;

    public void setThrowOnError(boolean shouldThrow) {
        this.shouldThrow = shouldThrow;
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        if (clientResponseContext.hasEntity()) {
            try {
                this.validerContentHash(clientResponseContext);
            }
            catch (Exception e) {
                LoggingUtil.logResponse(clientResponseContext);
                this.logOrThrow("Det skjedde en feil under signatursjekk: " + e.getMessage(), e);
            }
        }
    }

    private void validerContentHash(ClientResponseContext response) {
        try {
            String hashHeader = (String)response.getHeaders().getFirst((Object)"X-Content-SHA256");
            if (StringUtils.isBlank((CharSequence)hashHeader)) {
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Mangler X-Content-SHA256-header - server-signatur kunne ikke valideres");
            }
            byte[] entityBytes = IOUtils.toByteArray((InputStream)response.getEntityStream());
            this.validerBytesMotHashHeader(hashHeader, entityBytes);
            response.setEntityStream((InputStream)new ByteArrayInputStream(entityBytes));
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Det skjedde en feil under uthenting av innhold for validering av X-Content-SHA256-header - server-signatur kunne ikke valideres");
        }
    }

    private void validerBytesMotHashHeader(String serverHash, byte[] entityBytes) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(entityBytes, 0, entityBytes.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        String ourHash = new String(Base64.encode((byte[])result));
        if (!serverHash.equals(ourHash)) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "X-Content-SHA256-header matchet ikke innholdet - server-signatur er feil.");
        }
    }

    private void logOrThrow(String message, Exception e) {
        if (this.shouldThrow) {
            if (e instanceof DigipostClientException) {
                throw (DigipostClientException)e;
            }
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, message);
        }
        LOG.warn("Feil under validering av server signatur: '" + e.getMessage() + "'. " + (LOG.isDebugEnabled() ? "" : "Konfigurer debug-logging for " + LOG.getName() + " for \u00e5 se full stacktrace."));
        LOG.debug(e.getMessage(), (Throwable)e);
    }
}

