/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.response;

import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.util.DateUtils;
import no.digipost.api.client.util.LoggingUtil;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseDateFilter
implements ClientResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseDateFilter.class);
    private static final int AKSEPTABEL_TIDSDIFFERANSE_MINUTTER = 5;
    private boolean shouldThrow = true;

    public void setThrowOnError(boolean shouldThrow) {
        this.shouldThrow = shouldThrow;
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        String dateHeader = (String)clientResponseContext.getHeaders().getFirst((Object)"Date");
        try {
            if (!StringUtils.isNotBlank((CharSequence)dateHeader)) {
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Mangler Date-header - server-signatur kunne ikke sjekkes");
            }
            this.sjekkDato(dateHeader);
        }
        catch (Exception e) {
            LoggingUtil.logResponse(clientResponseContext);
            if (this.shouldThrow) {
                if (e instanceof DigipostClientException) {
                    throw (DigipostClientException)e;
                }
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Det skjedde en feil under signatursjekk: " + e.getMessage());
            }
            LOG.warn("Feil under validering av server-signatur: '" + e.getMessage() + "'. " + (LOG.isDebugEnabled() ? "" : "Konfigurer debug-logging for " + LOG.getName() + " for \u00e5 se full stacktrace."));
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }

    private void sjekkDato(String dateOnRFC1123Format) {
        try {
            DateTime date = DateUtils.parseDate(dateOnRFC1123Format);
            this.sjekkAtDatoHeaderIkkeErForGammel(dateOnRFC1123Format, date);
            this.sjekkAtDatoHeaderIkkeErForNy(dateOnRFC1123Format, date);
        }
        catch (IllegalArgumentException e) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Date-header kunne ikke parses - server-signatur kunne ikke sjekkes");
        }
    }

    private void sjekkAtDatoHeaderIkkeErForGammel(String headerDate, DateTime parsedDate) {
        if (parsedDate.isBefore((ReadableInstant)DateTime.now().minusMinutes(5))) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Date-header fra server er for gammel: " + headerDate);
        }
    }

    private void sjekkAtDatoHeaderIkkeErForNy(String headerDate, DateTime parsedDate) {
        if (parsedDate.isAfter((ReadableInstant)DateTime.now().plusMinutes(5))) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Date-header fra server er for ny: " + headerDate);
        }
    }
}

